/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client.impl;

import com.aliyun.mqs.client.impl.AbstractAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.HttpMethod;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.common.parser.ResultParseException;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.model.ChangeVisibilityTimeoutRequest;
import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.MessageDeserializer;
import java.net.URI;

public class ChangeVisibilityTimeoutAction
extends AbstractAction<ChangeVisibilityTimeoutRequest, String> {
    public ChangeVisibilityTimeoutAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.PUT, "ChangeVisibilityTimeout", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(ChangeVisibilityTimeoutRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath() + "/" + "messages" + "?ReceiptHandle=" + reqObject.getReceiptHandle() + "&VisibilityTimeout=" + reqObject.getVisibilityTimeout());
        return requestMessage;
    }

    @Override
    protected ResultParser<String> buildResultParser() {
        return new ResultParser<String>(){

            @Override
            public String parse(ResponseMessage response) throws ResultParseException {
                MessageDeserializer deserializer = new MessageDeserializer();
                try {
                    Message msg = deserializer.deserialize(response.getContent());
                    if (msg != null) {
                        return msg.getReceiptHandle();
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

