/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client.impl;

import com.aliyun.mqs.client.impl.AbstractAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.HttpMethod;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.common.parser.ResultParseException;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.model.CreateQueueRequest;
import com.aliyun.mqs.model.QueueMetaSerializer;
import java.io.InputStream;
import java.net.URI;

public class CreateQueueAction
extends AbstractAction<CreateQueueRequest, String> {
    public CreateQueueAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.PUT, "CreateQueue", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(CreateQueueRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath());
        QueueMetaSerializer serializer = new QueueMetaSerializer();
        try {
            InputStream is = serializer.serialize(reqObject.getQueueMeta(), "UTF-8");
            requestMessage.setContent(is);
            requestMessage.setContentLength(is.available());
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        return requestMessage;
    }

    @Override
    public ResultParser<String> buildResultParser() {
        return new ResultParser<String>(){

            @Override
            public String parse(ResponseMessage response) throws ResultParseException {
                return response.getHeaders().get("Location");
            }
        };
    }
}

