/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client.impl;

import com.aliyun.mqs.client.impl.AbstractAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.HttpMethod;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.common.parser.ResultParseException;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.MessageDeserializer;
import com.aliyun.mqs.model.ReceiveMessageRequest;
import java.net.URI;

public class ReceiveMessageAction
extends AbstractAction<ReceiveMessageRequest, Message> {
    public ReceiveMessageAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "ReceiveMessage", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(ReceiveMessageRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        String uri = reqObject.getRequestPath() + "/" + "messages";
        if (reqObject.getWaitSeconds() != null && reqObject.getWaitSeconds() > 0) {
            uri = uri + "?waitseconds=" + reqObject.getWaitSeconds();
        }
        requestMessage.setResourcePath(uri);
        return requestMessage;
    }

    @Override
    protected ResultParser<Message> buildResultParser() {
        return new ResultParser<Message>(){

            @Override
            public Message parse(ResponseMessage response) throws ResultParseException {
                MessageDeserializer deserializer = new MessageDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

