/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.common.http;

import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.comm.ExecutionContext;
import com.aliyun.mqs.common.comm.RetryStrategy;
import com.aliyun.mqs.common.http.ClientConfiguration;
import com.aliyun.mqs.common.http.HttpCallback;
import com.aliyun.mqs.common.http.HttpFactory;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;

public class DefaultServiceClient
extends ServiceClient {
    private HttpAsyncClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = new HttpFactory().createHttpAsyncClient(config);
        this.start();
    }

    @Override
    public <T> Future<HttpResponse> sendRequestCore(ServiceClient.Request request, ExecutionContext context, HttpCallback<T> callback) throws IOException {
        assert (request != null && context != null);
        HttpRequestBase httpRequest = new HttpFactory().createHttpRequest(request, context);
        Future future = this.httpClient.execute((HttpUriRequest)httpRequest, callback);
        return future;
    }

    public void start() {
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient) {
            ((CloseableHttpAsyncClient)this.httpClient).start();
        }
    }

    @Override
    public void close() {
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient) {
            try {
                ((CloseableHttpAsyncClient)this.httpClient).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException && ((errorCode = ((ClientException)ex).getErrorCode()).equals("ConnectionTimeout") || errorCode.equals("SocketTimeout"))) {
                return true;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

