/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.model;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public final class Message {
    protected String messageId;
    protected String receiptHandle;
    protected int priority = 8;
    protected Date enqueueTime;
    protected Date nextVisibleTime;
    protected Date firstDequeueTime;
    protected int dequeueCount;
    protected String messageBodyMD5;
    protected int delaySeconds;
    private String messageBodyText;
    private byte[] messageBodyBytes;
    private MessageBodyType rawBodyType;
    protected ErrorMessageResult errorMessage;

    public Message() {
    }

    public Message(String messageBody) {
        this.setMessageBody(messageBody);
    }

    public Message(byte[] messageBody) {
        this.setMessageBody(messageBody);
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(int delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public void setReceiptHandle(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }

    public Date getEnqueueTime() {
        return this.enqueueTime;
    }

    public Date getNextVisibleTime() {
        return this.nextVisibleTime;
    }

    public Date getFirstDequeueTime() {
        return this.firstDequeueTime;
    }

    public int getDequeueCount() {
        return this.dequeueCount;
    }

    public String getMessageBodyMD5() {
        return this.messageBodyMD5;
    }

    public void setMessageBody(byte[] messageBody) {
        this.messageBodyBytes = messageBody == null ? new byte[]{} : messageBody;
        this.messageBodyText = null;
        this.rawBodyType = MessageBodyType.BYTE;
    }

    protected void setMessageBody(String messageBody, MessageBodyType bodyType) {
        this.messageBodyText = messageBody;
        this.messageBodyBytes = null;
        this.rawBodyType = bodyType;
    }

    public void setMessageBody(String messageBody) {
        this.setMessageBody(messageBody, MessageBodyType.STRING);
    }

    public String getMessageBodyAsBase64() {
        if (this.rawBodyType == MessageBodyType.BYTE) {
            return Base64.encodeBase64String((byte[])this.messageBodyBytes);
        }
        if (this.rawBodyType == MessageBodyType.BASE64) {
            return this.messageBodyText;
        }
        try {
            byte[] bytes = this.messageBodyText.getBytes("UTF-8");
            return Base64.encodeBase64String((byte[])bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding :UTF-8");
        }
    }

    public String getMessageBodyAsString() {
        if (this.rawBodyType == MessageBodyType.STRING) {
            return this.messageBodyText;
        }
        if (this.rawBodyType == MessageBodyType.BASE64) {
            try {
                byte[] bytes = this.messageBodyText.getBytes("UTF-8");
                return new String(Base64.decodeBase64((byte[])bytes), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Not support encoding :UTF-8");
            }
        }
        try {
            return new String(this.messageBodyBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding :UTF-8");
        }
    }

    public byte[] getMessageBodyAsBytes() {
        if (this.rawBodyType == MessageBodyType.BYTE) {
            return this.messageBodyBytes;
        }
        if (this.rawBodyType == MessageBodyType.BASE64) {
            try {
                byte[] bytes = this.messageBodyText.getBytes("UTF-8");
                return Base64.decodeBase64((byte[])bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Not support encoding :UTF-8");
            }
        }
        try {
            return this.messageBodyText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding :UTF-8");
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ErrorMessageResult getErrorMessageDetail() {
        return this.errorMessage;
    }

    public boolean isErrorMessage() {
        return this.errorMessage != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("MessageId:\"");
        sb.append(this.messageId);
        sb.append("\"");
        sb.append(",");
        if (this.receiptHandle != null) {
            sb.append("ReceiptHandle:\"");
            sb.append(this.receiptHandle);
            sb.append("\"");
            sb.append(",");
        }
        sb.append("DequeueCount:\"");
        sb.append(this.dequeueCount);
        sb.append("\"");
        sb.append(",");
        if (this.enqueueTime != null) {
            sb.append("EnqueueTime:\"");
            sb.append(this.enqueueTime);
            sb.append("\"");
            sb.append(",");
        }
        if (this.firstDequeueTime != null) {
            sb.append("FirstDequeueTime:\"");
            sb.append(this.firstDequeueTime);
            sb.append("\"");
            sb.append(",");
        }
        if (this.nextVisibleTime != null) {
            sb.append("NextVisibleTime:\"");
            sb.append(this.nextVisibleTime);
            sb.append("\"");
            sb.append(",");
        }
        if (this.messageBodyBytes != null && this.messageBodyBytes.length > 0 || this.messageBodyText != null && !this.messageBodyText.equals("")) {
            sb.append("MessageBody:\"");
            sb.append(this.getMessageBodyAsString());
            sb.append("\"");
            sb.append(",");
        }
        if (this.messageBodyMD5 != null) {
            sb.append("MessageBodyMD5:\"");
            sb.append(this.messageBodyMD5);
            sb.append("\"");
            sb.append(",");
        }
        sb.append("Priority:\"");
        sb.append(this.priority);
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    static enum MessageBodyType {
        BYTE,
        STRING,
        BASE64;

    }

    protected static class ErrorMessageResult {
        protected String errorCode;
        protected String errorMessage;

        protected ErrorMessageResult() {
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

