/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.model;

import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.serialize.XMLSerializer;
import com.aliyun.mqs.model.serialize.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageListSerializer
extends XMLSerializer<List<Message>> {
    @Override
    public InputStream serialize(List<Message> msgs, String encoding) throws Exception {
        Document doc = factory.newDocumentBuilder().newDocument();
        Element messages = doc.createElementNS("http://mqs.aliyuncs.com/doc/v1", "Messages");
        doc.appendChild(messages);
        for (Message msg : msgs) {
            Element root = doc.createElement("Message");
            messages.appendChild(root);
            Element node = this.safeCreateContentElement(doc, "MessageBody", msg.getMessageBodyAsBase64(), "");
            if (node != null) {
                root.appendChild(node);
            }
            if ((node = this.safeCreateContentElement(doc, "DelaySeconds", msg.getDelaySeconds(), null)) != null) {
                root.appendChild(node);
            }
            if ((node = this.safeCreateContentElement(doc, "Priority", msg.getPriority(), null)) == null) continue;
            root.appendChild(node);
        }
        String xml = XmlUtil.xmlNodeToString(doc, encoding);
        return new ByteArrayInputStream(xml.getBytes(encoding));
    }
}

