/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.consumer.AbstractBatchPutRunnable;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.queue.DataQueue;
import com.aliyun.hitsdb.client.util.guava.RateLimiter;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.UniqueUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPutRunnable
extends AbstractBatchPutRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchPutRunnable.class);
    private final AbstractBatchPutCallback<?> batchPutCallback;

    public BatchPutRunnable(DataQueue dataQueue, HttpClient httpclient, Config config, CountDownLatch countDownLatch, RateLimiter rateLimiter) {
        super(dataQueue, httpclient, countDownLatch, config, rateLimiter);
        this.batchPutCallback = config.getBatchPutCallback();
    }

    @Override
    public void run() {
        Map<String, String> paramsMap = AbstractBatchPutCallback.getPutQueryParamMap(this.batchPutCallback);
        Point waitPoint = null;
        boolean readyClose = false;
        int waitTimeLimit = this.batchPutTimeLimit / 3;
        while (!readyClose || waitPoint != null) {
            long t0 = System.currentTimeMillis();
            ArrayList<Point> pointList = new ArrayList<Point>(this.batchSize);
            if (waitPoint != null) {
                pointList.add(waitPoint);
                waitPoint = null;
            }
            for (int i = pointList.size(); i < this.batchSize; ++i) {
                try {
                    long t1;
                    Point point = this.dataQueue.receive(waitTimeLimit);
                    if (point != null) {
                        if (this.rateLimiter != null) {
                            this.rateLimiter.acquire();
                        }
                        pointList.add(point);
                    }
                    if ((t1 = System.currentTimeMillis()) - t0 <= (long)this.batchPutTimeLimit) continue;
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    LOGGER.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
                break;
            }
            if (pointList.size() == 0 && !readyClose) {
                try {
                    Point newPoint;
                    waitPoint = newPoint = this.dataQueue.receive();
                    continue;
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    LOGGER.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
            }
            if (pointList.size() == 0) continue;
            UniqueUtil.uniquePoints(pointList, this.config.isDeduplicationEnable());
            String strJson = this.serialize(pointList);
            this.sendHttpRequest(pointList, strJson, paramsMap);
        }
        if (readyClose) {
            this.countDownLatch.countDown();
        }
    }

    private void sendHttpRequest(List<Point> pointList, String strJson, Map<String, String> paramsMap) {
        String address = this.tsdbHttpClient.getAddressAndSemaphoreAcquire();
        if (this.batchPutCallback != null) {
            FutureCallback<HttpResponse> postHttpCallback = this.httpResponseCallbackFactory.createBatchPutDataCallback(address, this.batchPutCallback, pointList, this.config, this.config.getBatchPutRetryCount());
            try {
                this.tsdbHttpClient.postToAddress(address, "/api/put", strJson, paramsMap, postHttpCallback);
            }
            catch (Exception ex) {
                this.semaphoreManager.release(address);
                this.batchPutCallback.failed(address, pointList, ex);
            }
        } else {
            FutureCallback<HttpResponse> noLogicBatchPutHttpFutureCallback = this.httpResponseCallbackFactory.createNoLogicBatchPutHttpFutureCallback(address, pointList, this.config, this.config.getBatchPutRetryCount());
            try {
                this.tsdbHttpClient.postToAddress(address, "/api/put", strJson, noLogicBatchPutHttpFutureCallback);
            }
            catch (Exception ex) {
                this.semaphoreManager.release(address);
                noLogicBatchPutHttpFutureCallback.failed(ex);
            }
        }
    }

    private String serialize(List<Point> pointList) {
        return JSON.toJSONString(pointList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }
}

