/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.request.SubQuery;
import com.aliyun.hitsdb.client.value.type.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Query
extends JSONValue {
    private Long start;
    private Long end;
    private Boolean msResolution;
    private Boolean delete;
    private List<SubQuery> queries;
    @JSONField(serialize=false)
    private boolean showType;
    @JSONField(serialize=false)
    private Class<?> type;
    private Map<String, Map<String, Integer>> hint;
    @JSONField(name="type")
    private String queryType;

    public static Builder start(long startTime) {
        return new Builder(startTime);
    }

    public static Builder start(Date startDate) {
        long startTime = startDate.getTime();
        return new Builder(startTime);
    }

    public static Builder timeRange(Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        return new Builder(startTime, endTime);
    }

    public static Builder timeRange(long startTime, long endTime) {
        return new Builder(startTime, endTime);
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public Boolean getMsResolution() {
        return this.msResolution;
    }

    public List<SubQuery> getQueries() {
        return this.queries;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean showType) {
        this.showType = showType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Map<String, Map<String, Integer>> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, Map<String, Integer>> hint) {
        this.hint = hint;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType.getName();
    }

    public static class Builder {
        private Long startTime;
        private Long endTime;
        private Boolean msResolution;
        private Boolean delete;
        private List<SubQuery> subQueryList = new ArrayList<SubQuery>();
        private boolean showType;
        private Class<?> type;
        private String queryType;
        private Map<String, Map<String, Integer>> hint;
        private static final long MIN_START_TIME = 4294968L;
        private static final long MAX_END_TIME = 9999999999999L;

        public Builder(long startTime) {
            this.startTime = startTime;
        }

        public Builder(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Builder end(Date endDate) {
            this.endTime = endDate.getTime();
            return this;
        }

        public Builder end(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder msResolution(Boolean msResolution) {
            this.msResolution = msResolution != false ? Boolean.valueOf(true) : null;
            return this;
        }

        public Builder msResolution() {
            this.msResolution = true;
            return this;
        }

        public Builder queryType(QueryType queryType) {
            this.queryType = queryType.getName();
            return this;
        }

        public Builder sub(SubQuery ... subQuerys) {
            int newIndex = this.subQueryList.size();
            int i = 0;
            for (SubQuery subQuery : subQuerys) {
                if (subQuery.getIndex() <= 0) {
                    subQuery.setIndex(newIndex + i);
                }
                subQuery.setIndex(newIndex + i);
                this.subQueryList.add(subQuery);
                ++i;
            }
            return this;
        }

        public Builder sub(Collection<SubQuery> subQuerys) {
            int newIndex = this.subQueryList.size();
            int i = 0;
            for (SubQuery subQuery : subQuerys) {
                if (subQuery.getIndex() <= 0) {
                    subQuery.setIndex(newIndex + i);
                }
                this.subQueryList.add(subQuery);
                ++i;
            }
            return this;
        }

        public Builder delete() {
            this.delete = true;
            return this;
        }

        public Builder delete(boolean delete) {
            this.delete = delete ? Boolean.valueOf(true) : null;
            return this;
        }

        public Builder showType() {
            this.showType = true;
            return this;
        }

        public Builder withType(Class<?> type) {
            this.showType = true;
            this.type = type;
            return this;
        }

        public Builder hint(Map<String, Map<String, Integer>> hint) {
            this.hint = hint;
            return this;
        }

        public Query build() {
            Query query = new Query();
            if (this.startTime == null) {
                throw new IllegalArgumentException("the start time must be set");
            }
            if (this.startTime < 4294968L) {
                throw new IllegalArgumentException("the start time must be greater than 4294968");
            }
            query.start = this.startTime;
            if (this.endTime != null) {
                if (this.endTime > 9999999999999L) {
                    throw new IllegalArgumentException("the end time must be less than9999999999999");
                }
                if (this.endTime < this.startTime) {
                    throw new IllegalArgumentException("the end time (" + this.endTime + ") must be greater than start time (" + this.startTime + ")");
                }
            }
            query.end = this.endTime;
            query.queries = this.subQueryList;
            query.delete = this.delete;
            query.msResolution = this.msResolution;
            query.showType = this.showType;
            query.type = this.type;
            query.hint = this.hint;
            query.queryType = this.queryType;
            return query;
        }
    }
}

