/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.hitsdb.client.value.request.ByteArrayValue;
import com.aliyun.hitsdb.client.value.request.ComplexValue;
import com.aliyun.hitsdb.client.value.request.GeoPointValue;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultDpsSerializer
implements ObjectSerializer,
ObjectDeserializer {
    static final Logger log = LoggerFactory.getLogger(QueryResultDpsSerializer.class);

    public LinkedHashMap<Long, Object> deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object parse = parser.parse();
        if (parse == null) {
            return null;
        }
        TreeMap retMap = new TreeMap();
        for (Map.Entry entry : ((JSONObject)parse).entrySet()) {
            JSONObject jsonObject;
            if (entry.getValue() instanceof JSONObject && ComplexValue.isJsonObjectTypeMatch(jsonObject = (JSONObject)entry.getValue())) {
                if (ByteArrayValue.isJsonObjectTypeMatch(jsonObject)) {
                    ByteArrayValue bv = (ByteArrayValue)JSON.parseObject((String)jsonObject.toJSONString(), ByteArrayValue.class);
                    entry.setValue(bv.decode());
                } else if (GeoPointValue.isJsonObjectTypeMatch(jsonObject)) {
                    GeoPointValue gp = (GeoPointValue)JSON.parseObject((String)jsonObject.toJSONString(), GeoPointValue.class);
                    entry.setValue(gp);
                } else {
                    log.error("Illegal value type {}", (Object)jsonObject);
                    throw new IllegalArgumentException("Illegal value type " + jsonObject);
                }
            }
            retMap.put(Long.parseLong(String.valueOf(entry.getKey())), entry.getValue());
        }
        return new LinkedHashMap<Long, Object>(retMap);
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        LinkedHashMap map = (LinkedHashMap)object;
        LinkedHashMap original = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof byte[])) continue;
            Object value = entry.getValue();
            ByteArrayValue bv = new ByteArrayValue((byte[])value);
            entry.setValue(bv);
            original.put(entry.getKey(), value);
        }
        serializer.write((Object)map);
        for (Map.Entry entry : original.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public int getFastMatchToken() {
        return 0;
    }
}

