/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.client.impl.topic.CreateTopicAction;
import com.aliyun.mns.client.impl.topic.DeleteTopicAction;
import com.aliyun.mns.client.impl.topic.GetSubscriptionAttrAction;
import com.aliyun.mns.client.impl.topic.GetTopicAttrAction;
import com.aliyun.mns.client.impl.topic.ListSubscriptionAction;
import com.aliyun.mns.client.impl.topic.PublishMessageAction;
import com.aliyun.mns.client.impl.topic.SetSubscriptionAttrAction;
import com.aliyun.mns.client.impl.topic.SetTopicAttrAction;
import com.aliyun.mns.client.impl.topic.SubscribeAction;
import com.aliyun.mns.client.impl.topic.UnsubscribeAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.model.AttributesValidationResult;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.PagingListResult;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.SubscriptionMeta;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.TopicMeta;
import com.aliyun.mns.model.request.topic.CreateTopicRequest;
import com.aliyun.mns.model.request.topic.DeleteTopicRequest;
import com.aliyun.mns.model.request.topic.GetSubscriptionAttrRequest;
import com.aliyun.mns.model.request.topic.GetTopicAttrRequest;
import com.aliyun.mns.model.request.topic.ListSubscriptionRequest;
import com.aliyun.mns.model.request.topic.PublishMessageRequest;
import com.aliyun.mns.model.request.topic.SetSubscriptionAttrRequest;
import com.aliyun.mns.model.request.topic.SetTopicAttrRequest;
import com.aliyun.mns.model.request.topic.SubscribeRequest;
import com.aliyun.mns.model.request.topic.UnsubscribeRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudTopic {
    public static Logger logger = LoggerFactory.getLogger(CloudTopic.class);
    private ServiceClient serviceClient;
    private String topicURL;
    private ServiceCredentials credentials;
    private URI endpoint;
    private String accountId;
    private String region;
    private Map<String, String> customHeaders = null;

    protected CloudTopic(String topicName, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.serviceClient = client;
        this.credentials = credentials;
        this.endpoint = endpoint;
        if (StringUtils.isEmpty((CharSequence)topicName)) {
            throw new NullPointerException("TopicName can not be empty.");
        }
        String host = endpoint.getHost();
        String[] hostPieces = host.split("\\.");
        this.accountId = hostPieces[0];
        this.region = hostPieces[2].split("-internal")[0];
        String uri = endpoint.toString();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        this.topicURL = uri = uri + "topics/" + topicName;
    }

    void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    private String getTopicName() {
        String topicName = null;
        if (this.topicURL.startsWith(this.endpoint.toString())) {
            topicName = this.topicURL.substring(this.endpoint.toString().length() + 1 + "topics/".length());
        }
        while (topicName != null && !topicName.trim().isEmpty() && topicName.startsWith("/")) {
            topicName = topicName.substring(1);
        }
        if (topicName == null || topicName.trim().isEmpty()) {
            logger.warn("topic name is null or empty");
            throw new NullPointerException("Topic Name can not be null.");
        }
        return topicName;
    }

    public String getTopicURL() {
        return this.topicURL;
    }

    public String create() throws ServiceException {
        String topicName = this.getTopicName();
        TopicMeta meta = new TopicMeta();
        meta.setTopicName(topicName);
        meta.setTopicURL(this.topicURL);
        return this.create(meta);
    }

    public String create(TopicMeta meta) throws ServiceException {
        CreateTopicAction action = new CreateTopicAction(this.serviceClient, this.credentials, this.endpoint);
        CreateTopicRequest request = new CreateTopicRequest();
        request.setRequestPath(this.topicURL);
        String topicName = this.getTopicName();
        if (meta == null) {
            meta = new TopicMeta();
            meta.setTopicName(topicName);
            meta.setTopicURL(this.topicURL);
            logger.debug("topic meta is null, we use default meta");
        }
        if (meta.getTopicName() == null || meta.getTopicName().trim().isEmpty()) {
            meta.setTopicName(topicName);
            meta.setTopicURL(this.topicURL);
            logger.debug("topic name in meta is null or empty, we get it from topic url");
        }
        if (!meta.getTopicName().equals(topicName)) {
            logger.warn("TopicName conflict between meta topic name and  topic url offered");
            throw new ClientException("TopicName conflict between meta topic name and  topic url offered", action.getUserRequestId());
        }
        request.setTopicMeta(meta);
        request.setRequestPath("topics/" + topicName);
        return (String)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncSetAttribute(TopicMeta meta, AsyncCallback<Void> callback) throws ServiceException {
        SetTopicAttrAction action = new SetTopicAttrAction(this.serviceClient, this.credentials, this.endpoint);
        SetTopicAttrRequest request = new SetTopicAttrRequest();
        request.setTopicMeta(meta);
        request.setRequestPath("queues/" + meta.getTopicName());
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public TopicMeta getAttribute() throws ServiceException {
        GetTopicAttrAction action = new GetTopicAttrAction(this.serviceClient, this.credentials, this.endpoint);
        GetTopicAttrRequest request = new GetTopicAttrRequest();
        request.setRequestPath(this.topicURL);
        TopicMeta meta = (TopicMeta)action.executeWithCustomHeaders(request, this.customHeaders);
        meta.setTopicURL(this.topicURL);
        return meta;
    }

    public void setAttribute(TopicMeta meta) throws ServiceException {
        SetTopicAttrAction action = new SetTopicAttrAction(this.serviceClient, this.credentials, this.endpoint);
        SetTopicAttrRequest request = new SetTopicAttrRequest();
        request.setTopicMeta(meta);
        request.setRequestPath("topics/" + meta.getTopicName());
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<TopicMeta> asyncGetAttribute(AsyncCallback<TopicMeta> callback) throws ServiceException {
        GetTopicAttrAction action = new GetTopicAttrAction(this.serviceClient, this.credentials, this.endpoint);
        GetTopicAttrRequest request = new GetTopicAttrRequest();
        request.setRequestPath(this.topicURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public void delete() throws ServiceException {
        DeleteTopicAction action = new DeleteTopicAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteTopicRequest request = new DeleteTopicRequest();
        request.setRequestPath(this.topicURL);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncDelete(AsyncCallback<Void> callback) throws ServiceException {
        DeleteTopicAction action = new DeleteTopicAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteTopicRequest request = new DeleteTopicRequest();
        request.setRequestPath(this.topicURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public String subscribe(SubscriptionMeta meta) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)meta.getSubscriptionName())) {
            throw new NullPointerException("subscriptionName can not be empty.");
        }
        SubscribeRequest request = new SubscribeRequest();
        SubscribeAction action = new SubscribeAction(this.serviceClient, this.credentials, this.endpoint);
        request.setMeta(meta);
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + meta.getSubscriptionName());
        String url = (String)action.executeWithCustomHeaders(request, this.customHeaders);
        return url;
    }

    public AsyncResult<String> asyncSubscribe(SubscriptionMeta meta, AsyncCallback<String> callback) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)meta.getSubscriptionName())) {
            throw new NullPointerException("subscriptionName can not be empty.");
        }
        SubscribeRequest request = new SubscribeRequest();
        SubscribeAction action = new SubscribeAction(this.serviceClient, this.credentials, this.endpoint);
        request.setMeta(meta);
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + meta.getSubscriptionName());
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public void setSubscriptionAttr(SubscriptionMeta meta) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)meta.getSubscriptionName())) {
            throw new NullPointerException("subscriptionName can not be empty.");
        }
        SetSubscriptionAttrRequest request = new SetSubscriptionAttrRequest();
        SetSubscriptionAttrAction action = new SetSubscriptionAttrAction(this.serviceClient, this.credentials, this.endpoint);
        request.setMeta(meta);
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + meta.getSubscriptionName());
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncSetSubscriptionAttr(SubscriptionMeta meta, AsyncCallback<Void> callback) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)meta.getSubscriptionName())) {
            throw new NullPointerException("subscriptionName can not be empty.");
        }
        SetSubscriptionAttrRequest request = new SetSubscriptionAttrRequest();
        SetSubscriptionAttrAction action = new SetSubscriptionAttrAction(this.serviceClient, this.credentials, this.endpoint);
        request.setMeta(meta);
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + meta.getSubscriptionName());
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public SubscriptionMeta getSubscriptionAttr(String subscriptionName) throws ServiceException {
        GetSubscriptionAttrRequest request = new GetSubscriptionAttrRequest();
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + subscriptionName);
        GetSubscriptionAttrAction action = new GetSubscriptionAttrAction(this.serviceClient, this.credentials, this.endpoint);
        return (SubscriptionMeta)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<SubscriptionMeta> asyncGetSubscriptionAttr(String subscriptionName, AsyncCallback<SubscriptionMeta> callback) throws ServiceException {
        GetSubscriptionAttrRequest request = new GetSubscriptionAttrRequest();
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + subscriptionName);
        GetSubscriptionAttrAction action = new GetSubscriptionAttrAction(this.serviceClient, this.credentials, this.endpoint);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public void unsubscribe(String subscriptionName) throws ServiceException {
        UnsubscribeRequest request = new UnsubscribeRequest();
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + subscriptionName);
        UnsubscribeAction action = new UnsubscribeAction(this.serviceClient, this.credentials, this.endpoint);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncUnsubscribe(String subscriptionName, AsyncCallback<Void> callback) throws ServiceException {
        UnsubscribeRequest request = new UnsubscribeRequest();
        request.setRequestPath(this.topicURL + "/" + "subscriptions" + "/" + subscriptionName);
        UnsubscribeAction action = new UnsubscribeAction(this.serviceClient, this.credentials, this.endpoint);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    private PagingListResult<SubscriptionMeta> listSubscriptions(String prefix, String marker, Integer retNumber, boolean withMeta) throws ServiceException {
        ListSubscriptionRequest request = new ListSubscriptionRequest();
        ListSubscriptionAction action = new ListSubscriptionAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "subscriptions");
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        request.setWithMeta(withMeta);
        return (PagingListResult)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public PagingListResult<SubscriptionMeta> listSubscriptions(String prefix, String marker, Integer retNumber) throws ServiceException {
        return this.listSubscriptions(prefix, marker, retNumber, true);
    }

    public PagingListResult<String> listSubscriptionUrls(String prefix, String marker, Integer retNumber) throws ServiceException {
        PagingListResult<SubscriptionMeta> list = this.listSubscriptions(prefix, marker, retNumber, false);
        PagingListResult<String> result = null;
        if (list != null && list.getResult() != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (SubscriptionMeta meta : list.getResult()) {
                tmp.add(meta.getSubscriptionURL());
            }
            result = new PagingListResult<String>();
            result.setResult(tmp);
            result.setMarker(list.getMarker());
        }
        return result;
    }

    public String generateQueueEndpoint(String queueName) {
        return "acs:mns:" + this.region + ":" + this.accountId + ":queues/" + queueName;
    }

    public String generateQueueEndpoint(String queueName, String region) {
        return "acs:mns:" + region + ":" + this.accountId + ":queues/" + queueName;
    }

    public String generateMailEndpoint(String mailAddress) {
        return "mail:directmail:" + mailAddress;
    }

    public String generateDayuEndpoint(String phone) {
        return "sms:dayu:" + phone;
    }

    public String generatePushEndpoint(String appKey) {
        return "push:" + appKey;
    }

    public String generateSmsEndpoint(String phone) {
        return "sms:directsms:" + phone;
    }

    public String generateSmsEndpoint() {
        return "sms:directsms:anonymous";
    }

    public String generateBatchSmsEndpoint() {
        return "sms:directsms:anonymous";
    }

    public TopicMessage publishMessage(TopicMessage msg) throws ServiceException {
        PublishMessageRequest request = new PublishMessageRequest();
        request.setMessage(msg);
        PublishMessageAction action = new PublishMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return (TopicMessage)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public TopicMessage publishMessage(RawTopicMessage msg, MessageAttributes messageAttributes) throws ServiceException {
        PublishMessageAction action = new PublishMessageAction(this.serviceClient, this.credentials, this.endpoint);
        AttributesValidationResult result = messageAttributes.validate();
        if (!result.isSuccess()) {
            throw new ClientException(result.getMessage(), action.getUserRequestId());
        }
        PublishMessageRequest request = new PublishMessageRequest();
        request.setMessage(msg);
        request.setMessageAttributes(messageAttributes);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return (TopicMessage)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<TopicMessage> asyncPublishMessage(TopicMessage msg, AsyncCallback<TopicMessage> callback) throws ServiceException {
        PublishMessageRequest request = new PublishMessageRequest();
        request.setMessage(msg);
        PublishMessageAction action = new PublishMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }
}

