/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.common.http;

import com.aliyun.mq.http.common.utils.VersionInfoUtils;
import shaded.org.apache.commons.lang3.builder.HashCodeBuilder;

public class ClientConfiguration
implements Cloneable {
    private static final String DEFAULT_USER_AGENT = VersionInfoUtils.getDefaultUserAgent();
    private String userAgent = DEFAULT_USER_AGENT;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private int maxErrorRetry = 3;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private int maxConnections = 4000;
    private int maxConnectionsPerRoute = 4000;
    private int socketTimeout = 33000;
    private int connectionTimeout = 30000;
    private boolean soKeepAlive = true;
    private int ioReactorThreadCount = Runtime.getRuntime().availableProcessors();
    private boolean exceptContinue = true;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.maxConnections);
        hcb.append(this.maxConnectionsPerRoute);
        hcb.append(this.socketTimeout);
        hcb.append(this.connectionTimeout);
        hcb.append(this.soKeepAlive);
        hcb.append(this.exceptContinue);
        hcb.append(this.proxyPort);
        hcb.append(this.proxyHost);
        hcb.append(this.proxyUsername);
        hcb.append(this.proxyPassword);
        hcb.append(this.proxyDomain);
        hcb.append(this.proxyWorkstation);
        return hcb.build();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientConfiguration) {
            ClientConfiguration conf = (ClientConfiguration)obj;
            return this.maxConnections == conf.maxConnections && this.maxConnectionsPerRoute == conf.maxConnectionsPerRoute && this.socketTimeout == conf.socketTimeout && this.connectionTimeout == conf.connectionTimeout && this.proxyPort == conf.proxyPort && this.proxyHost == null ? conf.proxyHost == null : (this.proxyHost.equals(conf.proxyHost) && this.proxyUsername == null ? conf.proxyUsername == null : (this.proxyUsername.equals(conf.proxyUsername) && this.proxyPassword == null ? conf.proxyPassword == null : (this.proxyPassword.equals(conf.proxyPassword) && this.proxyDomain == null ? conf.proxyDomain == null : (this.proxyDomain.equals(conf.proxyDomain) && this.proxyWorkstation == null ? conf.proxyWorkstation == null : this.proxyWorkstation.equals(conf.proxyWorkstation) && this.soKeepAlive == conf.soKeepAlive && this.exceptContinue == conf.exceptContinue))));
        }
        return super.equals(obj);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public boolean isExceptContinue() {
        return this.exceptContinue;
    }

    public void setExceptContinue(boolean exceptContinue) {
        this.exceptContinue = exceptContinue;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getIoReactorThreadCount() {
        return this.ioReactorThreadCount;
    }

    public void setIoReactorThreadCount(int ioReactorThreadCount) {
        this.ioReactorThreadCount = ioReactorThreadCount;
    }
}

