/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.SecurityUtils;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class AppRequestSigner
implements RequestSigner {
    private Account account;

    public AppRequestSigner(Account account) {
        this.account = account;
    }

    @Override
    public void sign(String resource, Request req) {
        Account.AccountProvider accountProvider = this.account.getType();
        switch (accountProvider) {
            case ALIYUN: {
                String providerStr = accountProvider.toString().toLowerCase();
                String signature = SecurityUtils.getApplicationSignature(providerStr, ((AliyunAccount)this.account).getAccessId(), this.getAliyunSignature(req));
                req.getHeaders().put("application-authentication", signature);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported account provider for application account.");
            }
        }
    }

    public String getAliyunSignature(Request request) {
        String strToSign = request.getHeaders().get("Authorization");
        return this.getAliyunSignature(strToSign);
    }

    public String getAliyunSignature(String strToSign) {
        byte[] crypto;
        if (StringUtils.isNullOrEmpty((String)strToSign)) {
            throw new RuntimeException("String to sign cannot be empty or null.");
        }
        try {
            crypto = SecurityUtils.hmacsha1Signature(strToSign.getBytes("UTF-8"), ((AliyunAccount)this.account).getAccessKey().getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return Base64.encodeBase64String((byte[])crypto).trim();
    }
}

