/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.commons.transport.Request;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtils {
    private static final String NEW_LINE = "\n";

    protected static void init() {
    }

    protected static String buildCanonicalString(String resource, Request request, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)((Object)request.getMethod()) + NEW_LINE);
        Map<String, String> headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String lowerKey;
                if (entry.getKey() == null || !(lowerKey = entry.getKey().toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith(prefix)) continue;
                headersToSign.put(lowerKey, entry.getValue());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        if (request.getParameters() != null) {
            for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                headersToSign.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : headersToSign.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(prefix)) {
                builder.append(key);
                builder.append(':');
                if (value != null) {
                    builder.append((Object)value);
                }
            } else {
                builder.append((Object)value);
            }
            builder.append(NEW_LINE);
        }
        builder.append(SecurityUtils.buildCanonicalizedResource(resource, request.getParameters()));
        return builder.toString();
    }

    protected static String buildCanonicalizedResource(String resource, Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        builder.append(resource);
        if (params != null && params.size() > 0) {
            Object[] names = params.keySet().toArray(new String[params.size()]);
            Arrays.sort(names);
            int separater = 63;
            for (Object name : names) {
                builder.append((char)separater);
                builder.append((String)name);
                String paramValue = params.get(name);
                if (paramValue != null && paramValue.length() > 0) {
                    builder.append("=").append(paramValue);
                }
                separater = 38;
            }
        }
        String str = builder.toString();
        return str;
    }

    protected static byte[] hmacsha1Signature(byte[] data, byte[] key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static PrivateKey getPrivateKey(byte[] encodedkey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedkey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    protected static byte[] signature(byte[] message, PrivateKey privateKey) throws Exception {
        Signature instance = Signature.getInstance("SHA1withRSA");
        instance.initSign(privateKey);
        instance.update(message);
        byte[] signature = instance.sign();
        return signature;
    }

    public static String md5Signature(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(message.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getApplicationSignature(String accountProvider, String accessId, String signedString) {
        String signature = String.format("account_provider:%s,signature_method:%s,access_id:%s,signature:%s", accountProvider, "hmac-sha1", accessId, signedString);
        return signature;
    }
}

