/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.transport;

import com.aliyun.odps.Survey;
import com.aliyun.odps.account.AuthorizationUtil;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.DefaultResponse;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.mail.internet.MimeUtility;

@Survey
public class DefaultConnection
implements Connection {
    private static final Logger log = Logger.getLogger(DefaultConnection.class.getName());
    private HttpURLConnection conn;

    @Override
    public void connect(Request req) throws IOException {
        URI u = req.getURI();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Connecting to " + u.toString());
        }
        if (u == null || u.getScheme() == null) {
            IllegalArgumentException e = new IllegalArgumentException("Request URI(http or https) required.");
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        try {
            String scheme = u.getScheme().toLowerCase();
            if (!(scheme.startsWith("http") || scheme.startsWith("https") || scheme.startsWith("test"))) {
                throw new IOException("Protocol not supported: " + u.getScheme());
            }
            this.conn = (HttpURLConnection)u.toURL().openConnection();
            this.conn.setDoInput(true);
            this.conn.setDoOutput(true);
            this.conn.setReadTimeout(req.getRestClient().getReadTimeout() * 1000);
            this.conn.setConnectTimeout(req.getRestClient().getConnectTimeout() * 1000);
            this.conn.setRequestMethod(req.getMethod().toString());
            if (req.getRestClient().isIgnoreCerts()) {
                AuthorizationUtil.ignoreHttpsCerts(this.conn);
            }
            if (req.getBody() != null) {
                long bodyLength = req.getBodyLength();
                this.conn.setRequestProperty("Content-Length", String.valueOf(bodyLength));
                this.conn.setFixedLengthStreamingMode((int)bodyLength);
            }
            if (req.getHeaders() != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Request headers: " + req.getHeaders().toString());
                }
                for (Map.Entry<String, String> kv : req.getHeaders().entrySet()) {
                    this.conn.setRequestProperty(kv.getKey(), kv.getValue());
                    if (!"Transfer-Encoding".equalsIgnoreCase(kv.getKey()) || !"chunked".equalsIgnoreCase(kv.getValue())) continue;
                    this.conn.setChunkedStreamingMode(1496);
                }
            }
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("Invalid request URI: " + u);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.checkConnection();
        return this.conn.getOutputStream();
    }

    @Override
    @Survey
    public Response getResponse() throws IOException {
        this.checkConnection();
        DefaultResponse resp = new DefaultResponse();
        resp.setStatus(this.conn.getResponseCode());
        resp.setMessage(this.conn.getResponseMessage());
        Map<String, List<String>> fields = this.conn.getHeaderFields();
        Map<String, String> headers = resp.getHeaders();
        for (Map.Entry<String, List<String>> kv : fields.entrySet()) {
            StringBuilder sb = new StringBuilder();
            String pad = "";
            for (String v : kv.getValue()) {
                sb.append(pad).append(MimeUtility.decodeText((String)v));
                pad = ",";
            }
            headers.put(kv.getKey(), sb.toString());
        }
        return resp;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        InputStream is = this.conn.getResponseCode() / 100 < 4 ? this.conn.getInputStream() : this.conn.getErrorStream();
        if (is == null) {
            throw new IOException("Invalid connection.");
        }
        String encoding = this.conn.getHeaderField("Content-Encoding");
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    @Override
    public void disconnect() throws IOException {
        this.checkConnection();
        this.conn.disconnect();
    }

    private void checkConnection() throws IOException {
        if (this.conn == null) {
            throw new IOException("Invalid connection.");
        }
    }
}

