/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Converter;
import com.aliyun.odps.simpleframework.xml.core.Expression;
import com.aliyun.odps.simpleframework.xml.core.Group;
import com.aliyun.odps.simpleframework.xml.core.Label;
import com.aliyun.odps.simpleframework.xml.core.LabelMap;
import com.aliyun.odps.simpleframework.xml.core.UnionException;
import com.aliyun.odps.simpleframework.xml.strategy.Type;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;

class CompositeUnion
implements Converter {
    private final LabelMap elements;
    private final Expression path;
    private final Context context;
    private final Group group;
    private final Type type;

    public CompositeUnion(Context context, Group group, Expression path, Type type) throws Exception {
        this.elements = group.getElements();
        this.context = context;
        this.group = group;
        this.type = type;
        this.path = path;
    }

    @Override
    public Object read(InputNode node) throws Exception {
        String name = node.getName();
        String element = this.path.getElement(name);
        Label label = (Label)this.elements.get(element);
        Converter converter = label.getConverter(this.context);
        return converter.read(node);
    }

    @Override
    public Object read(InputNode node, Object value) throws Exception {
        String name = node.getName();
        String element = this.path.getElement(name);
        Label label = (Label)this.elements.get(element);
        Converter converter = label.getConverter(this.context);
        return converter.read(node, value);
    }

    @Override
    public boolean validate(InputNode node) throws Exception {
        String name = node.getName();
        String element = this.path.getElement(name);
        Label label = (Label)this.elements.get(element);
        Converter converter = label.getConverter(this.context);
        return converter.validate(node);
    }

    @Override
    public void write(OutputNode node, Object object) throws Exception {
        Class<?> real = object.getClass();
        Label label = this.group.getLabel(real);
        if (label == null) {
            throw new UnionException("Value of %s not declared in %s with annotation %s", real, this.type, this.group);
        }
        this.write(node, object, label);
    }

    private void write(OutputNode node, Object object, Label label) throws Exception {
        label.getConverter(this.context).write(node, object);
    }
}

