/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.ClassType;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.Expression;
import com.aliyun.odps.simpleframework.xml.core.PathParser;
import com.aliyun.odps.simpleframework.xml.core.Support;
import com.aliyun.odps.simpleframework.xml.stream.Format;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.LimitedCache;

class ExpressionBuilder {
    private final Cache<Expression> cache = new LimitedCache<Expression>();
    private final Format format;
    private final Class type;

    public ExpressionBuilder(Detail detail, Support support) {
        this.format = support.getFormat();
        this.type = detail.getType();
    }

    public Expression build(String path) throws Exception {
        Expression expression = this.cache.fetch(path);
        if (expression == null) {
            return this.create(path);
        }
        return expression;
    }

    private Expression create(String path) throws Exception {
        ClassType detail = new ClassType(this.type);
        PathParser expression = new PathParser(path, detail, this.format);
        if (this.cache != null) {
            this.cache.cache(path, expression);
        }
        return expression;
    }
}

