/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.AttributeException;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.ElementException;
import com.aliyun.odps.simpleframework.xml.core.Expression;
import com.aliyun.odps.simpleframework.xml.core.Label;
import com.aliyun.odps.simpleframework.xml.core.LabelMap;
import com.aliyun.odps.simpleframework.xml.core.Model;
import com.aliyun.odps.simpleframework.xml.core.ModelList;
import com.aliyun.odps.simpleframework.xml.core.ModelMap;
import com.aliyun.odps.simpleframework.xml.core.PathException;
import com.aliyun.odps.simpleframework.xml.core.Policy;
import com.aliyun.odps.simpleframework.xml.core.TextException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

class TreeModel
implements Model {
    private Expression expression;
    private LabelMap attributes;
    private LabelMap elements;
    private ModelMap models;
    private OrderList order;
    private Policy policy;
    private Detail detail;
    private String name;
    private String prefix;
    private Label text;
    private Label list;
    private int index;

    public TreeModel(Policy policy, Detail detail) {
        this(policy, detail, null, null, 1);
    }

    public TreeModel(Policy policy, Detail detail, String name, String prefix, int index) {
        this.attributes = new LabelMap(policy);
        this.elements = new LabelMap(policy);
        this.models = new ModelMap(detail);
        this.order = new OrderList();
        this.detail = detail;
        this.policy = policy;
        this.prefix = prefix;
        this.index = index;
        this.name = name;
    }

    @Override
    public Model lookup(Expression path) {
        String name = path.getFirst();
        int index = path.getIndex();
        Model model = this.lookup(name, index);
        if (path.isPath()) {
            path = path.getPath(1, 0);
            if (model != null) {
                return model.lookup(path);
            }
        }
        return model;
    }

    @Override
    public void registerElement(String name) throws Exception {
        if (!this.order.contains(name)) {
            this.order.add(name);
        }
        this.elements.put(name, null);
    }

    @Override
    public void registerAttribute(String name) throws Exception {
        this.attributes.put(name, null);
    }

    @Override
    public void registerText(Label label) throws Exception {
        if (this.text != null) {
            throw new TextException("Duplicate text annotation on %s", label);
        }
        this.text = label;
    }

    @Override
    public void registerAttribute(Label label) throws Exception {
        String name = label.getName();
        if (this.attributes.get(name) != null) {
            throw new AttributeException("Duplicate annotation of name '%s' on %s", name, label);
        }
        this.attributes.put(name, label);
    }

    @Override
    public void registerElement(Label label) throws Exception {
        String name = label.getName();
        if (this.elements.get(name) != null) {
            throw new ElementException("Duplicate annotation of name '%s' on %s", name, label);
        }
        if (!this.order.contains(name)) {
            this.order.add(name);
        }
        if (label.isTextList()) {
            this.list = label;
        }
        this.elements.put(name, label);
    }

    @Override
    public ModelMap getModels() throws Exception {
        return this.models.getModels();
    }

    @Override
    public LabelMap getAttributes() throws Exception {
        return this.attributes.getLabels();
    }

    @Override
    public LabelMap getElements() throws Exception {
        return this.elements.getLabels();
    }

    @Override
    public boolean isModel(String name) {
        return this.models.containsKey(name);
    }

    @Override
    public boolean isElement(String name) {
        return this.elements.containsKey(name);
    }

    @Override
    public boolean isAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public Iterator<String> iterator() {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.order) {
            list.add(name);
        }
        return list.iterator();
    }

    @Override
    public void validate(Class type) throws Exception {
        this.validateExpressions(type);
        this.validateAttributes(type);
        this.validateElements(type);
        this.validateModels(type);
        this.validateText(type);
    }

    private void validateText(Class type) throws Exception {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Text annotation %s used with elements in %s", this.text, type);
            }
            if (this.isComposite()) {
                throw new TextException("Text annotation %s can not be used with paths in %s", this.text, type);
            }
        }
    }

    private void validateExpressions(Class type) throws Exception {
        for (Label label : this.elements) {
            if (label == null) continue;
            this.validateExpression(label);
        }
        for (Label label : this.attributes) {
            if (label == null) continue;
            this.validateExpression(label);
        }
        if (this.text != null) {
            this.validateExpression(this.text);
        }
    }

    private void validateExpression(Label label) throws Exception {
        Expression location = label.getExpression();
        if (this.expression != null) {
            String expect;
            String path = this.expression.getPath();
            if (!path.equals(expect = location.getPath())) {
                throw new PathException("Path '%s' does not match '%s' in %s", path, expect, this.detail);
            }
        } else {
            this.expression = location;
        }
    }

    private void validateModels(Class type) throws Exception {
        for (ModelList list : this.models) {
            int count = 1;
            for (Model model : list) {
                if (model == null) continue;
                String name = model.getName();
                int index = model.getIndex();
                if (index != count++) {
                    throw new ElementException("Path section '%s[%s]' is out of sequence in %s", name, index, type);
                }
                model.validate(type);
            }
        }
    }

    private void validateAttributes(Class type) throws Exception {
        Set keys = this.attributes.keySet();
        for (String name : keys) {
            Label label = (Label)this.attributes.get(name);
            if (label == null) {
                throw new AttributeException("Ordered attribute '%s' does not exist in %s", name, type);
            }
            if (this.expression == null) continue;
            this.expression.getAttribute(name);
        }
    }

    private void validateElements(Class type) throws Exception {
        Set keys = this.elements.keySet();
        for (String name : keys) {
            ModelList list = (ModelList)this.models.get(name);
            Label label = (Label)this.elements.get(name);
            if (list == null && label == null) {
                throw new ElementException("Ordered element '%s' does not exist in %s", name, type);
            }
            if (list != null && label != null && !list.isEmpty()) {
                throw new ElementException("Element '%s' is also a path name in %s", name, type);
            }
            if (this.expression == null) continue;
            this.expression.getElement(name);
        }
    }

    @Override
    public void register(Label label) throws Exception {
        if (label.isAttribute()) {
            this.registerAttribute(label);
        } else if (label.isText()) {
            this.registerText(label);
        } else {
            this.registerElement(label);
        }
    }

    @Override
    public Model lookup(String name, int index) {
        return this.models.lookup(name, index);
    }

    @Override
    public Model register(String name, String prefix, int index) throws Exception {
        Model model = this.models.lookup(name, index);
        if (model == null) {
            return this.create(name, prefix, index);
        }
        return model;
    }

    private Model create(String name, String prefix, int index) throws Exception {
        TreeModel model = new TreeModel(this.policy, this.detail, name, prefix, index);
        if (name != null) {
            this.models.register(name, model);
            this.order.add(name);
        }
        return model;
    }

    @Override
    public boolean isComposite() {
        for (ModelList list : this.models) {
            for (Model model : list) {
                if (model == null || model.isEmpty()) continue;
                return true;
            }
        }
        return !this.models.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        return !this.isComposite();
    }

    @Override
    public Label getText() {
        if (this.list != null) {
            return this.list;
        }
        return this.text;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.format("model '%s[%s]'", this.name, this.index);
    }

    private static class OrderList
    extends ArrayList<String> {
    }
}

