/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;

public final class IdleConnectionReaper
extends Thread {
    private static final Log log = LogFactory.getLog(IdleConnectionReaper.class);
    private static final int REAP_INTERVAL_MILLISECONDS = 60000;
    private static final ArrayList<ClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    private volatile boolean shuttingDown;

    private IdleConnectionReaper() {
        super("idle_connection_reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(ClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.add(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(ClientConnectionManager connectionManager) {
        boolean b = connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return b;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block6: while (true) {
            if (this.shuttingDown) {
                log.debug((Object)"Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(60000L);
                List connectionManagers = null;
                Class<IdleConnectionReaper> clazz = IdleConnectionReaper.class;
                // MONITORENTER : com.aliyun.oss.common.comm.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : clazz
                Iterator i$ = connectionManagers.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    ClientConnectionManager connectionManager = (ClientConnectionManager)i$.next();
                    try {
                        connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Exception ex) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)"Unable to close idle connections", (Throwable)ex);
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Reaper thread: ", t);
                continue;
            }
            break;
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    static synchronized int size() {
        return connectionManagers.size();
    }
}

