/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx;

import com.alibaba.schedulerx.SchedulerxProperties;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SchedulerxWorker.class})
@ConditionalOnProperty(prefix="spring.schedulerx2", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SchedulerxProperties.class})
public class SchedulerxAutoConfigure {
    @Autowired
    private SchedulerxProperties properties;

    @Bean
    public SchedulerxWorker schedulerxWorker() {
        SchedulerxWorker schedulerxWorker = new SchedulerxWorker();
        schedulerxWorker.setDomainName(this.properties.getDomainName());
        schedulerxWorker.setGroupId(this.properties.getGroupId());
        schedulerxWorker.setEnableBatchWork(this.properties.isEnableBatchWork());
        schedulerxWorker.setDisableSites(this.properties.getDisableSites());
        schedulerxWorker.setEnableSites(this.properties.getEnableSites());
        schedulerxWorker.setDisableUnits(this.properties.getDisableUnits());
        schedulerxWorker.setEnableUnits(this.properties.getEnableUnits());
        schedulerxWorker.setAppKey(this.properties.getAppKey());
        schedulerxWorker.setAliyunAccessKey(this.properties.getAliyunAccessKey());
        schedulerxWorker.setAliyunSecretKey(this.properties.getAliyunSecretKey());
        schedulerxWorker.setNamespace(this.properties.getNamespace());
        schedulerxWorker.setHost(this.properties.getHost());
        schedulerxWorker.setPort(this.properties.getPort());
        schedulerxWorker.setEndpoint(this.properties.getEndpoint());
        schedulerxWorker.setNamespaceSource(this.properties.getNamespaceSource());
        schedulerxWorker.setMaxTaskBodySize(this.properties.getMaxTaskBodySize());
        schedulerxWorker.setBlockAppStart(this.properties.isBlockAppStart());
        schedulerxWorker.setSTSAccessKey(this.properties.getStsAccessKey());
        schedulerxWorker.setSTSSecretKey(this.properties.getStsSecretKey());
        schedulerxWorker.setSTSSecretToken(this.properties.getStsToken());
        schedulerxWorker.setSlsCollectorEnable(this.properties.isSlsCollectorEnable());
        schedulerxWorker.setShareContainerPool(this.properties.isShareContainerPool());
        if (this.properties.isShareContainerPool()) {
            schedulerxWorker.setSharePoolSize(this.properties.getSharePoolSize());
        }
        if (this.properties.getEndpointPort() != null && !this.properties.getEndpointPort().isEmpty()) {
            schedulerxWorker.setEndpointPort(Integer.parseInt(this.properties.getEndpointPort()));
        }
        ConfigUtil.getWorkerConfig().setProperty("stater.mode", (Object)"springboot");
        return schedulerxWorker;
    }
}

