/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appfabric.model.S3Bucket;

@SdkInternalApi
public class S3BucketMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3BucketMarshaller instance = new S3BucketMarshaller();

    public static S3BucketMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Bucket s3Bucket, ProtocolMarshaller protocolMarshaller) {
        if (s3Bucket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Bucket.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

