/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ConnectorOAuthRequest;
import com.amazonaws.services.appflow.model.transform.OAuth2CredentialsMarshaller;
import java.io.Serializable;

public class OAuth2Credentials
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String refreshToken;
    private ConnectorOAuthRequest oAuthRequest;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2Credentials withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2Credentials withClientSecret(String clientSecret) {
        this.setClientSecret(clientSecret);
        return this;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OAuth2Credentials withAccessToken(String accessToken) {
        this.setAccessToken(accessToken);
        return this;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public OAuth2Credentials withRefreshToken(String refreshToken) {
        this.setRefreshToken(refreshToken);
        return this;
    }

    public void setOAuthRequest(ConnectorOAuthRequest oAuthRequest) {
        this.oAuthRequest = oAuthRequest;
    }

    public ConnectorOAuthRequest getOAuthRequest() {
        return this.oAuthRequest;
    }

    public OAuth2Credentials withOAuthRequest(ConnectorOAuthRequest oAuthRequest) {
        this.setOAuthRequest(oAuthRequest);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getClientSecret() != null) {
            sb.append("ClientSecret: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccessToken() != null) {
            sb.append("AccessToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRefreshToken() != null) {
            sb.append("RefreshToken: ").append(this.getRefreshToken()).append(",");
        }
        if (this.getOAuthRequest() != null) {
            sb.append("OAuthRequest: ").append(this.getOAuthRequest());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Credentials)) {
            return false;
        }
        OAuth2Credentials other = (OAuth2Credentials)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getClientSecret() == null ^ this.getClientSecret() == null) {
            return false;
        }
        if (other.getClientSecret() != null && !other.getClientSecret().equals(this.getClientSecret())) {
            return false;
        }
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) {
            return false;
        }
        if (other.getAccessToken() != null && !other.getAccessToken().equals(this.getAccessToken())) {
            return false;
        }
        if (other.getRefreshToken() == null ^ this.getRefreshToken() == null) {
            return false;
        }
        if (other.getRefreshToken() != null && !other.getRefreshToken().equals(this.getRefreshToken())) {
            return false;
        }
        if (other.getOAuthRequest() == null ^ this.getOAuthRequest() == null) {
            return false;
        }
        return other.getOAuthRequest() == null || other.getOAuthRequest().equals(this.getOAuthRequest());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getClientSecret() == null ? 0 : this.getClientSecret().hashCode());
        hashCode = 31 * hashCode + (this.getAccessToken() == null ? 0 : this.getAccessToken().hashCode());
        hashCode = 31 * hashCode + (this.getRefreshToken() == null ? 0 : this.getRefreshToken().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthRequest() == null ? 0 : this.getOAuthRequest().hashCode());
        return hashCode;
    }

    public OAuth2Credentials clone() {
        try {
            return (OAuth2Credentials)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OAuth2CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

