/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.Chunk;

@SdkInternalApi
public class ChunkMarshaller {
    private static final MarshallingInfo<Long> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Index").build();
    private static final MarshallingInfo<Long> LENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Length").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Checksum").build();
    private static final MarshallingInfo<String> CHECKSUMALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChecksumAlgorithm").build();
    private static final MarshallingInfo<String> CHUNKTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChunkToken").build();
    private static final ChunkMarshaller instance = new ChunkMarshaller();

    public static ChunkMarshaller getInstance() {
        return instance;
    }

    public void marshall(Chunk chunk, ProtocolMarshaller protocolMarshaller) {
        if (chunk == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)chunk.getIndex(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)chunk.getLength(), LENGTH_BINDING);
            protocolMarshaller.marshall((Object)chunk.getChecksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)chunk.getChecksumAlgorithm(), CHECKSUMALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)chunk.getChunkToken(), CHUNKTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

