/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.bedrock.AmazonBedrock;
import com.amazonaws.services.bedrock.AmazonBedrockClientBuilder;
import com.amazonaws.services.bedrock.model.AmazonBedrockException;
import com.amazonaws.services.bedrock.model.CreateModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.CreateModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.CreateProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.CreateProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.DeleteCustomModelRequest;
import com.amazonaws.services.bedrock.model.DeleteCustomModelResult;
import com.amazonaws.services.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.DeleteModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.DeleteProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.DeleteProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.GetCustomModelRequest;
import com.amazonaws.services.bedrock.model.GetCustomModelResult;
import com.amazonaws.services.bedrock.model.GetFoundationModelRequest;
import com.amazonaws.services.bedrock.model.GetFoundationModelResult;
import com.amazonaws.services.bedrock.model.GetModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.GetModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.GetModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.GetModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.GetProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.GetProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.ListCustomModelsRequest;
import com.amazonaws.services.bedrock.model.ListCustomModelsResult;
import com.amazonaws.services.bedrock.model.ListFoundationModelsRequest;
import com.amazonaws.services.bedrock.model.ListFoundationModelsResult;
import com.amazonaws.services.bedrock.model.ListModelCustomizationJobsRequest;
import com.amazonaws.services.bedrock.model.ListModelCustomizationJobsResult;
import com.amazonaws.services.bedrock.model.ListProvisionedModelThroughputsRequest;
import com.amazonaws.services.bedrock.model.ListProvisionedModelThroughputsResult;
import com.amazonaws.services.bedrock.model.ListTagsForResourceRequest;
import com.amazonaws.services.bedrock.model.ListTagsForResourceResult;
import com.amazonaws.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.PutModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.StopModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.StopModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.TagResourceRequest;
import com.amazonaws.services.bedrock.model.TagResourceResult;
import com.amazonaws.services.bedrock.model.UntagResourceRequest;
import com.amazonaws.services.bedrock.model.UntagResourceResult;
import com.amazonaws.services.bedrock.model.UpdateProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.UpdateProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.CreateModelCustomizationJobRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.CreateModelCustomizationJobResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.CreateProvisionedModelThroughputRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.CreateProvisionedModelThroughputResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteCustomModelRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteCustomModelResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteModelInvocationLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteModelInvocationLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteProvisionedModelThroughputRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.DeleteProvisionedModelThroughputResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.GetCustomModelRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.GetCustomModelResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.GetFoundationModelRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.GetFoundationModelResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.GetModelCustomizationJobRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.GetModelCustomizationJobResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.GetModelInvocationLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.GetModelInvocationLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.GetProvisionedModelThroughputRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.GetProvisionedModelThroughputResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ListCustomModelsRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.ListCustomModelsResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ListFoundationModelsRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.ListFoundationModelsResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ListModelCustomizationJobsRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.ListModelCustomizationJobsResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ListProvisionedModelThroughputsRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.ListProvisionedModelThroughputsResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.PutModelInvocationLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.PutModelInvocationLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.StopModelCustomizationJobRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.StopModelCustomizationJobResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.UpdateProvisionedModelThroughputRequestProtocolMarshaller;
import com.amazonaws.services.bedrock.model.transform.UpdateProvisionedModelThroughputResultJsonUnmarshaller;
import com.amazonaws.services.bedrock.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonBedrockClient
extends AmazonWebServiceClient
implements AmazonBedrock {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonBedrock.class);
    private static final String DEFAULT_SIGNING_NAME = "bedrock";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonBedrockException.class));

    public static AmazonBedrockClientBuilder builder() {
        return AmazonBedrockClientBuilder.standard();
    }

    AmazonBedrockClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonBedrockClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("bedrock.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/bedrock/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/bedrock/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateModelCustomizationJobResult createModelCustomizationJob(CreateModelCustomizationJobRequest request) {
        request = (CreateModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executeCreateModelCustomizationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelCustomizationJobResult executeCreateModelCustomizationJob(CreateModelCustomizationJobRequest createModelCustomizationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelCustomizationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelCustomizationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelCustomizationJobRequestProtocolMarshaller(protocolFactory).marshall((CreateModelCustomizationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createModelCustomizationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateModelCustomizationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateModelCustomizationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelCustomizationJobResult createModelCustomizationJobResult = (CreateModelCustomizationJobResult)response.getAwsResponse();
            return createModelCustomizationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProvisionedModelThroughputResult createProvisionedModelThroughput(CreateProvisionedModelThroughputRequest request) {
        request = (CreateProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executeCreateProvisionedModelThroughput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProvisionedModelThroughputResult executeCreateProvisionedModelThroughput(CreateProvisionedModelThroughputRequest createProvisionedModelThroughputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProvisionedModelThroughputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProvisionedModelThroughputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProvisionedModelThroughputRequestProtocolMarshaller(protocolFactory).marshall((CreateProvisionedModelThroughputRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProvisionedModelThroughputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProvisionedModelThroughput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProvisionedModelThroughputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProvisionedModelThroughputResult createProvisionedModelThroughputResult = (CreateProvisionedModelThroughputResult)response.getAwsResponse();
            return createProvisionedModelThroughputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCustomModelResult deleteCustomModel(DeleteCustomModelRequest request) {
        request = (DeleteCustomModelRequest)this.beforeClientExecution(request);
        return this.executeDeleteCustomModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCustomModelResult executeDeleteCustomModel(DeleteCustomModelRequest deleteCustomModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCustomModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCustomModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCustomModelRequestProtocolMarshaller(protocolFactory).marshall((DeleteCustomModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCustomModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCustomModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCustomModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCustomModelResult deleteCustomModelResult = (DeleteCustomModelResult)response.getAwsResponse();
            return deleteCustomModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteModelInvocationLoggingConfigurationResult deleteModelInvocationLoggingConfiguration(DeleteModelInvocationLoggingConfigurationRequest request) {
        request = (DeleteModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteModelInvocationLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteModelInvocationLoggingConfigurationResult executeDeleteModelInvocationLoggingConfiguration(DeleteModelInvocationLoggingConfigurationRequest deleteModelInvocationLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteModelInvocationLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteModelInvocationLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteModelInvocationLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteModelInvocationLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteModelInvocationLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteModelInvocationLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteModelInvocationLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteModelInvocationLoggingConfigurationResult deleteModelInvocationLoggingConfigurationResult = (DeleteModelInvocationLoggingConfigurationResult)response.getAwsResponse();
            return deleteModelInvocationLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProvisionedModelThroughputResult deleteProvisionedModelThroughput(DeleteProvisionedModelThroughputRequest request) {
        request = (DeleteProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executeDeleteProvisionedModelThroughput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProvisionedModelThroughputResult executeDeleteProvisionedModelThroughput(DeleteProvisionedModelThroughputRequest deleteProvisionedModelThroughputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProvisionedModelThroughputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProvisionedModelThroughputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProvisionedModelThroughputRequestProtocolMarshaller(protocolFactory).marshall((DeleteProvisionedModelThroughputRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProvisionedModelThroughputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProvisionedModelThroughput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProvisionedModelThroughputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProvisionedModelThroughputResult deleteProvisionedModelThroughputResult = (DeleteProvisionedModelThroughputResult)response.getAwsResponse();
            return deleteProvisionedModelThroughputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCustomModelResult getCustomModel(GetCustomModelRequest request) {
        request = (GetCustomModelRequest)this.beforeClientExecution(request);
        return this.executeGetCustomModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCustomModelResult executeGetCustomModel(GetCustomModelRequest getCustomModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCustomModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCustomModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCustomModelRequestProtocolMarshaller(protocolFactory).marshall((GetCustomModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCustomModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCustomModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCustomModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCustomModelResult getCustomModelResult = (GetCustomModelResult)response.getAwsResponse();
            return getCustomModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFoundationModelResult getFoundationModel(GetFoundationModelRequest request) {
        request = (GetFoundationModelRequest)this.beforeClientExecution(request);
        return this.executeGetFoundationModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFoundationModelResult executeGetFoundationModel(GetFoundationModelRequest getFoundationModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFoundationModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFoundationModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFoundationModelRequestProtocolMarshaller(protocolFactory).marshall((GetFoundationModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFoundationModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFoundationModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFoundationModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFoundationModelResult getFoundationModelResult = (GetFoundationModelResult)response.getAwsResponse();
            return getFoundationModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelCustomizationJobResult getModelCustomizationJob(GetModelCustomizationJobRequest request) {
        request = (GetModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executeGetModelCustomizationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelCustomizationJobResult executeGetModelCustomizationJob(GetModelCustomizationJobRequest getModelCustomizationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelCustomizationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelCustomizationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelCustomizationJobRequestProtocolMarshaller(protocolFactory).marshall((GetModelCustomizationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getModelCustomizationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetModelCustomizationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetModelCustomizationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelCustomizationJobResult getModelCustomizationJobResult = (GetModelCustomizationJobResult)response.getAwsResponse();
            return getModelCustomizationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelInvocationLoggingConfigurationResult getModelInvocationLoggingConfiguration(GetModelInvocationLoggingConfigurationRequest request) {
        request = (GetModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetModelInvocationLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelInvocationLoggingConfigurationResult executeGetModelInvocationLoggingConfiguration(GetModelInvocationLoggingConfigurationRequest getModelInvocationLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelInvocationLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelInvocationLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelInvocationLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetModelInvocationLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getModelInvocationLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetModelInvocationLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetModelInvocationLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelInvocationLoggingConfigurationResult getModelInvocationLoggingConfigurationResult = (GetModelInvocationLoggingConfigurationResult)response.getAwsResponse();
            return getModelInvocationLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProvisionedModelThroughputResult getProvisionedModelThroughput(GetProvisionedModelThroughputRequest request) {
        request = (GetProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executeGetProvisionedModelThroughput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProvisionedModelThroughputResult executeGetProvisionedModelThroughput(GetProvisionedModelThroughputRequest getProvisionedModelThroughputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProvisionedModelThroughputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProvisionedModelThroughputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProvisionedModelThroughputRequestProtocolMarshaller(protocolFactory).marshall((GetProvisionedModelThroughputRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProvisionedModelThroughputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProvisionedModelThroughput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProvisionedModelThroughputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProvisionedModelThroughputResult getProvisionedModelThroughputResult = (GetProvisionedModelThroughputResult)response.getAwsResponse();
            return getProvisionedModelThroughputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCustomModelsResult listCustomModels(ListCustomModelsRequest request) {
        request = (ListCustomModelsRequest)this.beforeClientExecution(request);
        return this.executeListCustomModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCustomModelsResult executeListCustomModels(ListCustomModelsRequest listCustomModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCustomModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCustomModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCustomModelsRequestProtocolMarshaller(protocolFactory).marshall((ListCustomModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCustomModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCustomModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCustomModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCustomModelsResult listCustomModelsResult = (ListCustomModelsResult)response.getAwsResponse();
            return listCustomModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFoundationModelsResult listFoundationModels(ListFoundationModelsRequest request) {
        request = (ListFoundationModelsRequest)this.beforeClientExecution(request);
        return this.executeListFoundationModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFoundationModelsResult executeListFoundationModels(ListFoundationModelsRequest listFoundationModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFoundationModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFoundationModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFoundationModelsRequestProtocolMarshaller(protocolFactory).marshall((ListFoundationModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFoundationModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFoundationModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFoundationModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFoundationModelsResult listFoundationModelsResult = (ListFoundationModelsResult)response.getAwsResponse();
            return listFoundationModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListModelCustomizationJobsResult listModelCustomizationJobs(ListModelCustomizationJobsRequest request) {
        request = (ListModelCustomizationJobsRequest)this.beforeClientExecution(request);
        return this.executeListModelCustomizationJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListModelCustomizationJobsResult executeListModelCustomizationJobs(ListModelCustomizationJobsRequest listModelCustomizationJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listModelCustomizationJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListModelCustomizationJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListModelCustomizationJobsRequestProtocolMarshaller(protocolFactory).marshall((ListModelCustomizationJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listModelCustomizationJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListModelCustomizationJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListModelCustomizationJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListModelCustomizationJobsResult listModelCustomizationJobsResult = (ListModelCustomizationJobsResult)response.getAwsResponse();
            return listModelCustomizationJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProvisionedModelThroughputsResult listProvisionedModelThroughputs(ListProvisionedModelThroughputsRequest request) {
        request = (ListProvisionedModelThroughputsRequest)this.beforeClientExecution(request);
        return this.executeListProvisionedModelThroughputs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProvisionedModelThroughputsResult executeListProvisionedModelThroughputs(ListProvisionedModelThroughputsRequest listProvisionedModelThroughputsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProvisionedModelThroughputsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProvisionedModelThroughputsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProvisionedModelThroughputsRequestProtocolMarshaller(protocolFactory).marshall((ListProvisionedModelThroughputsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProvisionedModelThroughputsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProvisionedModelThroughputs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProvisionedModelThroughputsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProvisionedModelThroughputsResult listProvisionedModelThroughputsResult = (ListProvisionedModelThroughputsResult)response.getAwsResponse();
            return listProvisionedModelThroughputsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutModelInvocationLoggingConfigurationResult putModelInvocationLoggingConfiguration(PutModelInvocationLoggingConfigurationRequest request) {
        request = (PutModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executePutModelInvocationLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutModelInvocationLoggingConfigurationResult executePutModelInvocationLoggingConfiguration(PutModelInvocationLoggingConfigurationRequest putModelInvocationLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putModelInvocationLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutModelInvocationLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutModelInvocationLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((PutModelInvocationLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putModelInvocationLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutModelInvocationLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutModelInvocationLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutModelInvocationLoggingConfigurationResult putModelInvocationLoggingConfigurationResult = (PutModelInvocationLoggingConfigurationResult)response.getAwsResponse();
            return putModelInvocationLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopModelCustomizationJobResult stopModelCustomizationJob(StopModelCustomizationJobRequest request) {
        request = (StopModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executeStopModelCustomizationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopModelCustomizationJobResult executeStopModelCustomizationJob(StopModelCustomizationJobRequest stopModelCustomizationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopModelCustomizationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopModelCustomizationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopModelCustomizationJobRequestProtocolMarshaller(protocolFactory).marshall((StopModelCustomizationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopModelCustomizationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopModelCustomizationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopModelCustomizationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopModelCustomizationJobResult stopModelCustomizationJobResult = (StopModelCustomizationJobResult)response.getAwsResponse();
            return stopModelCustomizationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProvisionedModelThroughputResult updateProvisionedModelThroughput(UpdateProvisionedModelThroughputRequest request) {
        request = (UpdateProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executeUpdateProvisionedModelThroughput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProvisionedModelThroughputResult executeUpdateProvisionedModelThroughput(UpdateProvisionedModelThroughputRequest updateProvisionedModelThroughputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProvisionedModelThroughputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProvisionedModelThroughputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProvisionedModelThroughputRequestProtocolMarshaller(protocolFactory).marshall((UpdateProvisionedModelThroughputRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProvisionedModelThroughputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProvisionedModelThroughput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProvisionedModelThroughputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProvisionedModelThroughputResult updateProvisionedModelThroughputResult = (UpdateProvisionedModelThroughputResult)response.getAwsResponse();
            return updateProvisionedModelThroughputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

