/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.LoggingConfig;

@SdkInternalApi
public class LoggingConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudWatchConfig").build();
    private static final MarshallingInfo<StructuredPojo> S3CONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Config").build();
    private static final MarshallingInfo<Boolean> TEXTDATADELIVERYENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("textDataDeliveryEnabled").build();
    private static final MarshallingInfo<Boolean> IMAGEDATADELIVERYENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDataDeliveryEnabled").build();
    private static final MarshallingInfo<Boolean> EMBEDDINGDATADELIVERYENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddingDataDeliveryEnabled").build();
    private static final LoggingConfigMarshaller instance = new LoggingConfigMarshaller();

    public static LoggingConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(LoggingConfig loggingConfig, ProtocolMarshaller protocolMarshaller) {
        if (loggingConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)loggingConfig.getCloudWatchConfig(), CLOUDWATCHCONFIG_BINDING);
            protocolMarshaller.marshall((Object)loggingConfig.getS3Config(), S3CONFIG_BINDING);
            protocolMarshaller.marshall((Object)loggingConfig.getTextDataDeliveryEnabled(), TEXTDATADELIVERYENABLED_BINDING);
            protocolMarshaller.marshall((Object)loggingConfig.getImageDataDeliveryEnabled(), IMAGEDATADELIVERYENABLED_BINDING);
            protocolMarshaller.marshall((Object)loggingConfig.getEmbeddingDataDeliveryEnabled(), EMBEDDINGDATADELIVERYENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

