/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.Credentials;
import com.amazonaws.services.datasync.model.DiscoveryServerConfiguration;
import com.amazonaws.services.datasync.model.DiscoverySystemType;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddStorageSystemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DiscoveryServerConfiguration serverConfiguration;
    private String systemType;
    private List<String> agentArns;
    private String cloudWatchLogGroupArn;
    private List<TagListEntry> tags;
    private String name;
    private String clientToken;
    private Credentials credentials;

    public void setServerConfiguration(DiscoveryServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public DiscoveryServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public AddStorageSystemRequest withServerConfiguration(DiscoveryServerConfiguration serverConfiguration) {
        this.setServerConfiguration(serverConfiguration);
        return this;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public AddStorageSystemRequest withSystemType(String systemType) {
        this.setSystemType(systemType);
        return this;
    }

    public AddStorageSystemRequest withSystemType(DiscoverySystemType systemType) {
        this.systemType = systemType.toString();
        return this;
    }

    public List<String> getAgentArns() {
        return this.agentArns;
    }

    public void setAgentArns(Collection<String> agentArns) {
        if (agentArns == null) {
            this.agentArns = null;
            return;
        }
        this.agentArns = new ArrayList<String>(agentArns);
    }

    public AddStorageSystemRequest withAgentArns(String ... agentArns) {
        if (this.agentArns == null) {
            this.setAgentArns(new ArrayList<String>(agentArns.length));
        }
        for (String ele : agentArns) {
            this.agentArns.add(ele);
        }
        return this;
    }

    public AddStorageSystemRequest withAgentArns(Collection<String> agentArns) {
        this.setAgentArns(agentArns);
        return this;
    }

    public void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
        this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
    }

    public String getCloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public AddStorageSystemRequest withCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
        this.setCloudWatchLogGroupArn(cloudWatchLogGroupArn);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public AddStorageSystemRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public AddStorageSystemRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AddStorageSystemRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public AddStorageSystemRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public AddStorageSystemRequest withCredentials(Credentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerConfiguration() != null) {
            sb.append("ServerConfiguration: ").append(this.getServerConfiguration()).append(",");
        }
        if (this.getSystemType() != null) {
            sb.append("SystemType: ").append(this.getSystemType()).append(",");
        }
        if (this.getAgentArns() != null) {
            sb.append("AgentArns: ").append(this.getAgentArns()).append(",");
        }
        if (this.getCloudWatchLogGroupArn() != null) {
            sb.append("CloudWatchLogGroupArn: ").append(this.getCloudWatchLogGroupArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddStorageSystemRequest)) {
            return false;
        }
        AddStorageSystemRequest other = (AddStorageSystemRequest)obj;
        if (other.getServerConfiguration() == null ^ this.getServerConfiguration() == null) {
            return false;
        }
        if (other.getServerConfiguration() != null && !other.getServerConfiguration().equals(this.getServerConfiguration())) {
            return false;
        }
        if (other.getSystemType() == null ^ this.getSystemType() == null) {
            return false;
        }
        if (other.getSystemType() != null && !other.getSystemType().equals(this.getSystemType())) {
            return false;
        }
        if (other.getAgentArns() == null ^ this.getAgentArns() == null) {
            return false;
        }
        if (other.getAgentArns() != null && !other.getAgentArns().equals(this.getAgentArns())) {
            return false;
        }
        if (other.getCloudWatchLogGroupArn() == null ^ this.getCloudWatchLogGroupArn() == null) {
            return false;
        }
        if (other.getCloudWatchLogGroupArn() != null && !other.getCloudWatchLogGroupArn().equals(this.getCloudWatchLogGroupArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        return other.getCredentials() == null || other.getCredentials().equals(this.getCredentials());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerConfiguration() == null ? 0 : this.getServerConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSystemType() == null ? 0 : this.getSystemType().hashCode());
        hashCode = 31 * hashCode + (this.getAgentArns() == null ? 0 : this.getAgentArns().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLogGroupArn() == null ? 0 : this.getCloudWatchLogGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        return hashCode;
    }

    public AddStorageSystemRequest clone() {
        return (AddStorageSystemRequest)super.clone();
    }
}

