/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.AzureAccessTier;
import com.amazonaws.services.datasync.model.AzureBlobAuthenticationType;
import com.amazonaws.services.datasync.model.AzureBlobSasConfiguration;
import com.amazonaws.services.datasync.model.AzureBlobType;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationAzureBlobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String containerUrl;
    private String authenticationType;
    private AzureBlobSasConfiguration sasConfiguration;
    private String blobType;
    private String accessTier;
    private String subdirectory;
    private List<String> agentArns;
    private List<TagListEntry> tags;

    public void setContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public CreateLocationAzureBlobRequest withContainerUrl(String containerUrl) {
        this.setContainerUrl(containerUrl);
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public CreateLocationAzureBlobRequest withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public CreateLocationAzureBlobRequest withAuthenticationType(AzureBlobAuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setSasConfiguration(AzureBlobSasConfiguration sasConfiguration) {
        this.sasConfiguration = sasConfiguration;
    }

    public AzureBlobSasConfiguration getSasConfiguration() {
        return this.sasConfiguration;
    }

    public CreateLocationAzureBlobRequest withSasConfiguration(AzureBlobSasConfiguration sasConfiguration) {
        this.setSasConfiguration(sasConfiguration);
        return this;
    }

    public void setBlobType(String blobType) {
        this.blobType = blobType;
    }

    public String getBlobType() {
        return this.blobType;
    }

    public CreateLocationAzureBlobRequest withBlobType(String blobType) {
        this.setBlobType(blobType);
        return this;
    }

    public CreateLocationAzureBlobRequest withBlobType(AzureBlobType blobType) {
        this.blobType = blobType.toString();
        return this;
    }

    public void setAccessTier(String accessTier) {
        this.accessTier = accessTier;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public CreateLocationAzureBlobRequest withAccessTier(String accessTier) {
        this.setAccessTier(accessTier);
        return this;
    }

    public CreateLocationAzureBlobRequest withAccessTier(AzureAccessTier accessTier) {
        this.accessTier = accessTier.toString();
        return this;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationAzureBlobRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public List<String> getAgentArns() {
        return this.agentArns;
    }

    public void setAgentArns(Collection<String> agentArns) {
        if (agentArns == null) {
            this.agentArns = null;
            return;
        }
        this.agentArns = new ArrayList<String>(agentArns);
    }

    public CreateLocationAzureBlobRequest withAgentArns(String ... agentArns) {
        if (this.agentArns == null) {
            this.setAgentArns(new ArrayList<String>(agentArns.length));
        }
        for (String ele : agentArns) {
            this.agentArns.add(ele);
        }
        return this;
    }

    public CreateLocationAzureBlobRequest withAgentArns(Collection<String> agentArns) {
        this.setAgentArns(agentArns);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationAzureBlobRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationAzureBlobRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerUrl() != null) {
            sb.append("ContainerUrl: ").append(this.getContainerUrl()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getSasConfiguration() != null) {
            sb.append("SasConfiguration: ").append(this.getSasConfiguration()).append(",");
        }
        if (this.getBlobType() != null) {
            sb.append("BlobType: ").append(this.getBlobType()).append(",");
        }
        if (this.getAccessTier() != null) {
            sb.append("AccessTier: ").append(this.getAccessTier()).append(",");
        }
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getAgentArns() != null) {
            sb.append("AgentArns: ").append(this.getAgentArns()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationAzureBlobRequest)) {
            return false;
        }
        CreateLocationAzureBlobRequest other = (CreateLocationAzureBlobRequest)obj;
        if (other.getContainerUrl() == null ^ this.getContainerUrl() == null) {
            return false;
        }
        if (other.getContainerUrl() != null && !other.getContainerUrl().equals(this.getContainerUrl())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getSasConfiguration() == null ^ this.getSasConfiguration() == null) {
            return false;
        }
        if (other.getSasConfiguration() != null && !other.getSasConfiguration().equals(this.getSasConfiguration())) {
            return false;
        }
        if (other.getBlobType() == null ^ this.getBlobType() == null) {
            return false;
        }
        if (other.getBlobType() != null && !other.getBlobType().equals(this.getBlobType())) {
            return false;
        }
        if (other.getAccessTier() == null ^ this.getAccessTier() == null) {
            return false;
        }
        if (other.getAccessTier() != null && !other.getAccessTier().equals(this.getAccessTier())) {
            return false;
        }
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getAgentArns() == null ^ this.getAgentArns() == null) {
            return false;
        }
        if (other.getAgentArns() != null && !other.getAgentArns().equals(this.getAgentArns())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerUrl() == null ? 0 : this.getContainerUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getSasConfiguration() == null ? 0 : this.getSasConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getBlobType() == null ? 0 : this.getBlobType().hashCode());
        hashCode = 31 * hashCode + (this.getAccessTier() == null ? 0 : this.getAccessTier().hashCode());
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getAgentArns() == null ? 0 : this.getAgentArns().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLocationAzureBlobRequest clone() {
        return (CreateLocationAzureBlobRequest)super.clone();
    }
}

