/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.ResourceDetails;
import java.util.List;

@SdkInternalApi
public class ResourceDetailsMarshaller {
    private static final MarshallingInfo<List> NETAPPONTAPSVMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetAppONTAPSVMs").build();
    private static final MarshallingInfo<List> NETAPPONTAPVOLUMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetAppONTAPVolumes").build();
    private static final MarshallingInfo<List> NETAPPONTAPCLUSTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetAppONTAPClusters").build();
    private static final ResourceDetailsMarshaller instance = new ResourceDetailsMarshaller();

    public static ResourceDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceDetails resourceDetails, ProtocolMarshaller protocolMarshaller) {
        if (resourceDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceDetails.getNetAppONTAPSVMs(), NETAPPONTAPSVMS_BINDING);
            protocolMarshaller.marshall(resourceDetails.getNetAppONTAPVolumes(), NETAPPONTAPVOLUMES_BINDING);
            protocolMarshaller.marshall(resourceDetails.getNetAppONTAPClusters(), NETAPPONTAPCLUSTERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

