/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdbelastic;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.docdbelastic.AmazonDocDBElasticAsync;
import com.amazonaws.services.docdbelastic.AmazonDocDBElasticAsyncClientBuilder;
import com.amazonaws.services.docdbelastic.AmazonDocDBElasticClient;
import com.amazonaws.services.docdbelastic.model.CreateClusterRequest;
import com.amazonaws.services.docdbelastic.model.CreateClusterResult;
import com.amazonaws.services.docdbelastic.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.docdbelastic.model.CreateClusterSnapshotResult;
import com.amazonaws.services.docdbelastic.model.DeleteClusterRequest;
import com.amazonaws.services.docdbelastic.model.DeleteClusterResult;
import com.amazonaws.services.docdbelastic.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.docdbelastic.model.DeleteClusterSnapshotResult;
import com.amazonaws.services.docdbelastic.model.GetClusterRequest;
import com.amazonaws.services.docdbelastic.model.GetClusterResult;
import com.amazonaws.services.docdbelastic.model.GetClusterSnapshotRequest;
import com.amazonaws.services.docdbelastic.model.GetClusterSnapshotResult;
import com.amazonaws.services.docdbelastic.model.ListClusterSnapshotsRequest;
import com.amazonaws.services.docdbelastic.model.ListClusterSnapshotsResult;
import com.amazonaws.services.docdbelastic.model.ListClustersRequest;
import com.amazonaws.services.docdbelastic.model.ListClustersResult;
import com.amazonaws.services.docdbelastic.model.ListTagsForResourceRequest;
import com.amazonaws.services.docdbelastic.model.ListTagsForResourceResult;
import com.amazonaws.services.docdbelastic.model.RestoreClusterFromSnapshotRequest;
import com.amazonaws.services.docdbelastic.model.RestoreClusterFromSnapshotResult;
import com.amazonaws.services.docdbelastic.model.TagResourceRequest;
import com.amazonaws.services.docdbelastic.model.TagResourceResult;
import com.amazonaws.services.docdbelastic.model.UntagResourceRequest;
import com.amazonaws.services.docdbelastic.model.UntagResourceResult;
import com.amazonaws.services.docdbelastic.model.UpdateClusterRequest;
import com.amazonaws.services.docdbelastic.model.UpdateClusterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDocDBElasticAsyncClient
extends AmazonDocDBElasticClient
implements AmazonDocDBElasticAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDocDBElasticAsyncClientBuilder asyncBuilder() {
        return AmazonDocDBElasticAsyncClientBuilder.standard();
    }

    AmazonDocDBElasticAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDocDBElasticAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterSnapshotResult> createClusterSnapshotAsync(CreateClusterSnapshotRequest request) {
        return this.createClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateClusterSnapshotResult> createClusterSnapshotAsync(CreateClusterSnapshotRequest request, final AsyncHandler<CreateClusterSnapshotRequest, CreateClusterSnapshotResult> asyncHandler) {
        final CreateClusterSnapshotRequest finalRequest = (CreateClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterSnapshotResult>(){

            @Override
            public CreateClusterSnapshotResult call() throws Exception {
                CreateClusterSnapshotResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeCreateClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterSnapshotResult> deleteClusterSnapshotAsync(DeleteClusterSnapshotRequest request) {
        return this.deleteClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteClusterSnapshotResult> deleteClusterSnapshotAsync(DeleteClusterSnapshotRequest request, final AsyncHandler<DeleteClusterSnapshotRequest, DeleteClusterSnapshotResult> asyncHandler) {
        final DeleteClusterSnapshotRequest finalRequest = (DeleteClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterSnapshotResult>(){

            @Override
            public DeleteClusterSnapshotResult call() throws Exception {
                DeleteClusterSnapshotResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeDeleteClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetClusterResult> getClusterAsync(GetClusterRequest request) {
        return this.getClusterAsync(request, null);
    }

    @Override
    public Future<GetClusterResult> getClusterAsync(GetClusterRequest request, final AsyncHandler<GetClusterRequest, GetClusterResult> asyncHandler) {
        final GetClusterRequest finalRequest = (GetClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClusterResult>(){

            @Override
            public GetClusterResult call() throws Exception {
                GetClusterResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeGetCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetClusterSnapshotResult> getClusterSnapshotAsync(GetClusterSnapshotRequest request) {
        return this.getClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<GetClusterSnapshotResult> getClusterSnapshotAsync(GetClusterSnapshotRequest request, final AsyncHandler<GetClusterSnapshotRequest, GetClusterSnapshotResult> asyncHandler) {
        final GetClusterSnapshotRequest finalRequest = (GetClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClusterSnapshotResult>(){

            @Override
            public GetClusterSnapshotResult call() throws Exception {
                GetClusterSnapshotResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeGetClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClusterSnapshotsResult> listClusterSnapshotsAsync(ListClusterSnapshotsRequest request) {
        return this.listClusterSnapshotsAsync(request, null);
    }

    @Override
    public Future<ListClusterSnapshotsResult> listClusterSnapshotsAsync(ListClusterSnapshotsRequest request, final AsyncHandler<ListClusterSnapshotsRequest, ListClusterSnapshotsResult> asyncHandler) {
        final ListClusterSnapshotsRequest finalRequest = (ListClusterSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClusterSnapshotsResult>(){

            @Override
            public ListClusterSnapshotsResult call() throws Exception {
                ListClusterSnapshotsResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeListClusterSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreClusterFromSnapshotResult> restoreClusterFromSnapshotAsync(RestoreClusterFromSnapshotRequest request) {
        return this.restoreClusterFromSnapshotAsync(request, null);
    }

    @Override
    public Future<RestoreClusterFromSnapshotResult> restoreClusterFromSnapshotAsync(RestoreClusterFromSnapshotRequest request, final AsyncHandler<RestoreClusterFromSnapshotRequest, RestoreClusterFromSnapshotResult> asyncHandler) {
        final RestoreClusterFromSnapshotRequest finalRequest = (RestoreClusterFromSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreClusterFromSnapshotResult>(){

            @Override
            public RestoreClusterFromSnapshotResult call() throws Exception {
                RestoreClusterFromSnapshotResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeRestoreClusterFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterAsync(request, null);
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request, final AsyncHandler<UpdateClusterRequest, UpdateClusterResult> asyncHandler) {
        final UpdateClusterRequest finalRequest = (UpdateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterResult>(){

            @Override
            public UpdateClusterResult call() throws Exception {
                UpdateClusterResult result = null;
                try {
                    result = AmazonDocDBElasticAsyncClient.this.executeUpdateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

