/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.eks.AmazonEKS;
import com.amazonaws.services.eks.AmazonEKSClientBuilder;
import com.amazonaws.services.eks.model.AmazonEKSException;
import com.amazonaws.services.eks.model.AssociateEncryptionConfigRequest;
import com.amazonaws.services.eks.model.AssociateEncryptionConfigResult;
import com.amazonaws.services.eks.model.AssociateIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.AssociateIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.CreateAddonRequest;
import com.amazonaws.services.eks.model.CreateAddonResult;
import com.amazonaws.services.eks.model.CreateClusterRequest;
import com.amazonaws.services.eks.model.CreateClusterResult;
import com.amazonaws.services.eks.model.CreateFargateProfileRequest;
import com.amazonaws.services.eks.model.CreateFargateProfileResult;
import com.amazonaws.services.eks.model.CreateNodegroupRequest;
import com.amazonaws.services.eks.model.CreateNodegroupResult;
import com.amazonaws.services.eks.model.DeleteAddonRequest;
import com.amazonaws.services.eks.model.DeleteAddonResult;
import com.amazonaws.services.eks.model.DeleteClusterRequest;
import com.amazonaws.services.eks.model.DeleteClusterResult;
import com.amazonaws.services.eks.model.DeleteFargateProfileRequest;
import com.amazonaws.services.eks.model.DeleteFargateProfileResult;
import com.amazonaws.services.eks.model.DeleteNodegroupRequest;
import com.amazonaws.services.eks.model.DeleteNodegroupResult;
import com.amazonaws.services.eks.model.DeregisterClusterRequest;
import com.amazonaws.services.eks.model.DeregisterClusterResult;
import com.amazonaws.services.eks.model.DescribeAddonConfigurationRequest;
import com.amazonaws.services.eks.model.DescribeAddonConfigurationResult;
import com.amazonaws.services.eks.model.DescribeAddonRequest;
import com.amazonaws.services.eks.model.DescribeAddonResult;
import com.amazonaws.services.eks.model.DescribeAddonVersionsRequest;
import com.amazonaws.services.eks.model.DescribeAddonVersionsResult;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.model.DescribeClusterResult;
import com.amazonaws.services.eks.model.DescribeFargateProfileRequest;
import com.amazonaws.services.eks.model.DescribeFargateProfileResult;
import com.amazonaws.services.eks.model.DescribeIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.DescribeIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.DescribeNodegroupRequest;
import com.amazonaws.services.eks.model.DescribeNodegroupResult;
import com.amazonaws.services.eks.model.DescribeUpdateRequest;
import com.amazonaws.services.eks.model.DescribeUpdateResult;
import com.amazonaws.services.eks.model.DisassociateIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.DisassociateIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.ListAddonsRequest;
import com.amazonaws.services.eks.model.ListAddonsResult;
import com.amazonaws.services.eks.model.ListClustersRequest;
import com.amazonaws.services.eks.model.ListClustersResult;
import com.amazonaws.services.eks.model.ListFargateProfilesRequest;
import com.amazonaws.services.eks.model.ListFargateProfilesResult;
import com.amazonaws.services.eks.model.ListIdentityProviderConfigsRequest;
import com.amazonaws.services.eks.model.ListIdentityProviderConfigsResult;
import com.amazonaws.services.eks.model.ListNodegroupsRequest;
import com.amazonaws.services.eks.model.ListNodegroupsResult;
import com.amazonaws.services.eks.model.ListTagsForResourceRequest;
import com.amazonaws.services.eks.model.ListTagsForResourceResult;
import com.amazonaws.services.eks.model.ListUpdatesRequest;
import com.amazonaws.services.eks.model.ListUpdatesResult;
import com.amazonaws.services.eks.model.RegisterClusterRequest;
import com.amazonaws.services.eks.model.RegisterClusterResult;
import com.amazonaws.services.eks.model.TagResourceRequest;
import com.amazonaws.services.eks.model.TagResourceResult;
import com.amazonaws.services.eks.model.UntagResourceRequest;
import com.amazonaws.services.eks.model.UntagResourceResult;
import com.amazonaws.services.eks.model.UpdateAddonRequest;
import com.amazonaws.services.eks.model.UpdateAddonResult;
import com.amazonaws.services.eks.model.UpdateClusterConfigRequest;
import com.amazonaws.services.eks.model.UpdateClusterConfigResult;
import com.amazonaws.services.eks.model.UpdateClusterVersionRequest;
import com.amazonaws.services.eks.model.UpdateClusterVersionResult;
import com.amazonaws.services.eks.model.UpdateNodegroupConfigRequest;
import com.amazonaws.services.eks.model.UpdateNodegroupConfigResult;
import com.amazonaws.services.eks.model.UpdateNodegroupVersionRequest;
import com.amazonaws.services.eks.model.UpdateNodegroupVersionResult;
import com.amazonaws.services.eks.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.AssociateEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.AssociateEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.AssociateIdentityProviderConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.AssociateIdentityProviderConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ClientExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.CreateAddonRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.CreateAddonResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.CreateClusterRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.CreateFargateProfileRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.CreateFargateProfileResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.CreateNodegroupRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.CreateNodegroupResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DeleteAddonRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DeleteAddonResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DeleteClusterRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DeleteFargateProfileRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DeleteFargateProfileResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DeleteNodegroupRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DeleteNodegroupResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DeregisterClusterRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DeregisterClusterResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonVersionsRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeAddonVersionsResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeClusterRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeClusterResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeFargateProfileRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeFargateProfileResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeIdentityProviderConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeIdentityProviderConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeNodegroupRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeNodegroupResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DescribeUpdateRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DescribeUpdateResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.DisassociateIdentityProviderConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.DisassociateIdentityProviderConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListAddonsRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListAddonsResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListClustersRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListFargateProfilesRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListFargateProfilesResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListIdentityProviderConfigsRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListIdentityProviderConfigsResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListNodegroupsRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListNodegroupsResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ListUpdatesRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.ListUpdatesResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.RegisterClusterRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.RegisterClusterResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ResourceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ResourcePropagationDelayExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ServerExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UnsupportedAvailabilityZoneExceptionUnmarshaller;
import com.amazonaws.services.eks.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UpdateAddonRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UpdateAddonResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UpdateClusterConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UpdateClusterConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UpdateClusterVersionRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UpdateClusterVersionResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UpdateNodegroupConfigRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UpdateNodegroupConfigResultJsonUnmarshaller;
import com.amazonaws.services.eks.model.transform.UpdateNodegroupVersionRequestProtocolMarshaller;
import com.amazonaws.services.eks.model.transform.UpdateNodegroupVersionResultJsonUnmarshaller;
import com.amazonaws.services.eks.waiters.AmazonEKSWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonEKSClient
extends AmazonWebServiceClient
implements AmazonEKS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonEKS.class);
    private static final String DEFAULT_SIGNING_NAME = "eks";
    private volatile AmazonEKSWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAvailabilityZoneException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedAvailabilityZoneExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourcePropagationDelayException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourcePropagationDelayExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonEKSException.class));

    public static AmazonEKSClientBuilder builder() {
        return AmazonEKSClientBuilder.standard();
    }

    AmazonEKSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonEKSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("eks.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/eks/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/eks/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateEncryptionConfigResult associateEncryptionConfig(AssociateEncryptionConfigRequest request) {
        request = (AssociateEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executeAssociateEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateEncryptionConfigResult executeAssociateEncryptionConfig(AssociateEncryptionConfigRequest associateEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((AssociateEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateEncryptionConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateEncryptionConfigResult associateEncryptionConfigResult = (AssociateEncryptionConfigResult)response.getAwsResponse();
            return associateEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateIdentityProviderConfigResult associateIdentityProviderConfig(AssociateIdentityProviderConfigRequest request) {
        request = (AssociateIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executeAssociateIdentityProviderConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateIdentityProviderConfigResult executeAssociateIdentityProviderConfig(AssociateIdentityProviderConfigRequest associateIdentityProviderConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateIdentityProviderConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateIdentityProviderConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateIdentityProviderConfigRequestProtocolMarshaller(protocolFactory).marshall((AssociateIdentityProviderConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateIdentityProviderConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateIdentityProviderConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateIdentityProviderConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateIdentityProviderConfigResult associateIdentityProviderConfigResult = (AssociateIdentityProviderConfigResult)response.getAwsResponse();
            return associateIdentityProviderConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAddonResult createAddon(CreateAddonRequest request) {
        request = (CreateAddonRequest)this.beforeClientExecution(request);
        return this.executeCreateAddon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAddonResult executeCreateAddon(CreateAddonRequest createAddonRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAddonRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAddonRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAddonRequestProtocolMarshaller(protocolFactory).marshall((CreateAddonRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAddonRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAddon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAddonResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAddonResult createAddonResult = (CreateAddonResult)response.getAwsResponse();
            return createAddonResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        request = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executeCreateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateClusterResult executeCreateCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestProtocolMarshaller(protocolFactory).marshall((CreateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFargateProfileResult createFargateProfile(CreateFargateProfileRequest request) {
        request = (CreateFargateProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateFargateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFargateProfileResult executeCreateFargateProfile(CreateFargateProfileRequest createFargateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFargateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFargateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFargateProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateFargateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFargateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFargateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFargateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFargateProfileResult createFargateProfileResult = (CreateFargateProfileResult)response.getAwsResponse();
            return createFargateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNodegroupResult createNodegroup(CreateNodegroupRequest request) {
        request = (CreateNodegroupRequest)this.beforeClientExecution(request);
        return this.executeCreateNodegroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNodegroupResult executeCreateNodegroup(CreateNodegroupRequest createNodegroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNodegroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNodegroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNodegroupRequestProtocolMarshaller(protocolFactory).marshall((CreateNodegroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNodegroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNodegroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNodegroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNodegroupResult createNodegroupResult = (CreateNodegroupResult)response.getAwsResponse();
            return createNodegroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAddonResult deleteAddon(DeleteAddonRequest request) {
        request = (DeleteAddonRequest)this.beforeClientExecution(request);
        return this.executeDeleteAddon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAddonResult executeDeleteAddon(DeleteAddonRequest deleteAddonRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAddonRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAddonRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAddonRequestProtocolMarshaller(protocolFactory).marshall((DeleteAddonRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAddonRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAddon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAddonResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAddonResult deleteAddonResult = (DeleteAddonResult)response.getAwsResponse();
            return deleteAddonResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        request = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executeDeleteCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteClusterResult executeDeleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestProtocolMarshaller(protocolFactory).marshall((DeleteClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFargateProfileResult deleteFargateProfile(DeleteFargateProfileRequest request) {
        request = (DeleteFargateProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteFargateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFargateProfileResult executeDeleteFargateProfile(DeleteFargateProfileRequest deleteFargateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFargateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFargateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFargateProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteFargateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFargateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFargateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFargateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFargateProfileResult deleteFargateProfileResult = (DeleteFargateProfileResult)response.getAwsResponse();
            return deleteFargateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNodegroupResult deleteNodegroup(DeleteNodegroupRequest request) {
        request = (DeleteNodegroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteNodegroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNodegroupResult executeDeleteNodegroup(DeleteNodegroupRequest deleteNodegroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNodegroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNodegroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNodegroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteNodegroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNodegroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNodegroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNodegroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNodegroupResult deleteNodegroupResult = (DeleteNodegroupResult)response.getAwsResponse();
            return deleteNodegroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterClusterResult deregisterCluster(DeregisterClusterRequest request) {
        request = (DeregisterClusterRequest)this.beforeClientExecution(request);
        return this.executeDeregisterCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterClusterResult executeDeregisterCluster(DeregisterClusterRequest deregisterClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterClusterRequestProtocolMarshaller(protocolFactory).marshall((DeregisterClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterClusterResult deregisterClusterResult = (DeregisterClusterResult)response.getAwsResponse();
            return deregisterClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAddonResult describeAddon(DescribeAddonRequest request) {
        request = (DescribeAddonRequest)this.beforeClientExecution(request);
        return this.executeDescribeAddon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAddonResult executeDescribeAddon(DescribeAddonRequest describeAddonRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddonRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddonRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddonRequestProtocolMarshaller(protocolFactory).marshall((DescribeAddonRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAddonRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAddon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddonResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddonResult describeAddonResult = (DescribeAddonResult)response.getAwsResponse();
            return describeAddonResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAddonConfigurationResult describeAddonConfiguration(DescribeAddonConfigurationRequest request) {
        request = (DescribeAddonConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeAddonConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAddonConfigurationResult executeDescribeAddonConfiguration(DescribeAddonConfigurationRequest describeAddonConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddonConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddonConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddonConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeAddonConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAddonConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAddonConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddonConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddonConfigurationResult describeAddonConfigurationResult = (DescribeAddonConfigurationResult)response.getAwsResponse();
            return describeAddonConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAddonVersionsResult describeAddonVersions(DescribeAddonVersionsRequest request) {
        request = (DescribeAddonVersionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeAddonVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAddonVersionsResult executeDescribeAddonVersions(DescribeAddonVersionsRequest describeAddonVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddonVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddonVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddonVersionsRequestProtocolMarshaller(protocolFactory).marshall((DescribeAddonVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAddonVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAddonVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddonVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddonVersionsResult describeAddonVersionsResult = (DescribeAddonVersionsResult)response.getAwsResponse();
            return describeAddonVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest request) {
        request = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executeDescribeCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeClusterResult executeDescribeCluster(DescribeClusterRequest describeClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClusterRequestProtocolMarshaller(protocolFactory).marshall((DescribeClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClusterResult describeClusterResult = (DescribeClusterResult)response.getAwsResponse();
            return describeClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFargateProfileResult describeFargateProfile(DescribeFargateProfileRequest request) {
        request = (DescribeFargateProfileRequest)this.beforeClientExecution(request);
        return this.executeDescribeFargateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFargateProfileResult executeDescribeFargateProfile(DescribeFargateProfileRequest describeFargateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFargateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFargateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFargateProfileRequestProtocolMarshaller(protocolFactory).marshall((DescribeFargateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFargateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFargateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFargateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFargateProfileResult describeFargateProfileResult = (DescribeFargateProfileResult)response.getAwsResponse();
            return describeFargateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeIdentityProviderConfigResult describeIdentityProviderConfig(DescribeIdentityProviderConfigRequest request) {
        request = (DescribeIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executeDescribeIdentityProviderConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeIdentityProviderConfigResult executeDescribeIdentityProviderConfig(DescribeIdentityProviderConfigRequest describeIdentityProviderConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityProviderConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityProviderConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityProviderConfigRequestProtocolMarshaller(protocolFactory).marshall((DescribeIdentityProviderConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeIdentityProviderConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeIdentityProviderConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeIdentityProviderConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeIdentityProviderConfigResult describeIdentityProviderConfigResult = (DescribeIdentityProviderConfigResult)response.getAwsResponse();
            return describeIdentityProviderConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNodegroupResult describeNodegroup(DescribeNodegroupRequest request) {
        request = (DescribeNodegroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeNodegroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNodegroupResult executeDescribeNodegroup(DescribeNodegroupRequest describeNodegroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNodegroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNodegroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNodegroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeNodegroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNodegroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeNodegroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNodegroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNodegroupResult describeNodegroupResult = (DescribeNodegroupResult)response.getAwsResponse();
            return describeNodegroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUpdateResult describeUpdate(DescribeUpdateRequest request) {
        request = (DescribeUpdateRequest)this.beforeClientExecution(request);
        return this.executeDescribeUpdate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUpdateResult executeDescribeUpdate(DescribeUpdateRequest describeUpdateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUpdateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUpdateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUpdateRequestProtocolMarshaller(protocolFactory).marshall((DescribeUpdateRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUpdateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUpdate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUpdateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUpdateResult describeUpdateResult = (DescribeUpdateResult)response.getAwsResponse();
            return describeUpdateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateIdentityProviderConfigResult disassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest request) {
        request = (DisassociateIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executeDisassociateIdentityProviderConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateIdentityProviderConfigResult executeDisassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest disassociateIdentityProviderConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateIdentityProviderConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateIdentityProviderConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateIdentityProviderConfigRequestProtocolMarshaller(protocolFactory).marshall((DisassociateIdentityProviderConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateIdentityProviderConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateIdentityProviderConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateIdentityProviderConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateIdentityProviderConfigResult disassociateIdentityProviderConfigResult = (DisassociateIdentityProviderConfigResult)response.getAwsResponse();
            return disassociateIdentityProviderConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAddonsResult listAddons(ListAddonsRequest request) {
        request = (ListAddonsRequest)this.beforeClientExecution(request);
        return this.executeListAddons(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAddonsResult executeListAddons(ListAddonsRequest listAddonsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAddonsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAddonsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAddonsRequestProtocolMarshaller(protocolFactory).marshall((ListAddonsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAddonsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAddons");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAddonsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAddonsResult listAddonsResult = (ListAddonsResult)response.getAwsResponse();
            return listAddonsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        request = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executeListClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListClustersResult executeListClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestProtocolMarshaller(protocolFactory).marshall((ListClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFargateProfilesResult listFargateProfiles(ListFargateProfilesRequest request) {
        request = (ListFargateProfilesRequest)this.beforeClientExecution(request);
        return this.executeListFargateProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFargateProfilesResult executeListFargateProfiles(ListFargateProfilesRequest listFargateProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFargateProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFargateProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFargateProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListFargateProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFargateProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFargateProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFargateProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFargateProfilesResult listFargateProfilesResult = (ListFargateProfilesResult)response.getAwsResponse();
            return listFargateProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIdentityProviderConfigsResult listIdentityProviderConfigs(ListIdentityProviderConfigsRequest request) {
        request = (ListIdentityProviderConfigsRequest)this.beforeClientExecution(request);
        return this.executeListIdentityProviderConfigs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIdentityProviderConfigsResult executeListIdentityProviderConfigs(ListIdentityProviderConfigsRequest listIdentityProviderConfigsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentityProviderConfigsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityProviderConfigsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityProviderConfigsRequestProtocolMarshaller(protocolFactory).marshall((ListIdentityProviderConfigsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIdentityProviderConfigsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIdentityProviderConfigs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIdentityProviderConfigsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIdentityProviderConfigsResult listIdentityProviderConfigsResult = (ListIdentityProviderConfigsResult)response.getAwsResponse();
            return listIdentityProviderConfigsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNodegroupsResult listNodegroups(ListNodegroupsRequest request) {
        request = (ListNodegroupsRequest)this.beforeClientExecution(request);
        return this.executeListNodegroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNodegroupsResult executeListNodegroups(ListNodegroupsRequest listNodegroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNodegroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNodegroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNodegroupsRequestProtocolMarshaller(protocolFactory).marshall((ListNodegroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNodegroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNodegroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNodegroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNodegroupsResult listNodegroupsResult = (ListNodegroupsResult)response.getAwsResponse();
            return listNodegroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUpdatesResult listUpdates(ListUpdatesRequest request) {
        request = (ListUpdatesRequest)this.beforeClientExecution(request);
        return this.executeListUpdates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUpdatesResult executeListUpdates(ListUpdatesRequest listUpdatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUpdatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUpdatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUpdatesRequestProtocolMarshaller(protocolFactory).marshall((ListUpdatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUpdatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUpdates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUpdatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUpdatesResult listUpdatesResult = (ListUpdatesResult)response.getAwsResponse();
            return listUpdatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterClusterResult registerCluster(RegisterClusterRequest request) {
        request = (RegisterClusterRequest)this.beforeClientExecution(request);
        return this.executeRegisterCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterClusterResult executeRegisterCluster(RegisterClusterRequest registerClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterClusterRequestProtocolMarshaller(protocolFactory).marshall((RegisterClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterClusterResult registerClusterResult = (RegisterClusterResult)response.getAwsResponse();
            return registerClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAddonResult updateAddon(UpdateAddonRequest request) {
        request = (UpdateAddonRequest)this.beforeClientExecution(request);
        return this.executeUpdateAddon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAddonResult executeUpdateAddon(UpdateAddonRequest updateAddonRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAddonRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAddonRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAddonRequestProtocolMarshaller(protocolFactory).marshall((UpdateAddonRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAddonRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAddon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAddonResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAddonResult updateAddonResult = (UpdateAddonResult)response.getAwsResponse();
            return updateAddonResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateClusterConfigResult updateClusterConfig(UpdateClusterConfigRequest request) {
        request = (UpdateClusterConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateClusterConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateClusterConfigResult executeUpdateClusterConfig(UpdateClusterConfigRequest updateClusterConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateClusterConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateClusterConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateClusterConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateClusterConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateClusterConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateClusterConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateClusterConfigResult updateClusterConfigResult = (UpdateClusterConfigResult)response.getAwsResponse();
            return updateClusterConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateClusterVersionResult updateClusterVersion(UpdateClusterVersionRequest request) {
        request = (UpdateClusterVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateClusterVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateClusterVersionResult executeUpdateClusterVersion(UpdateClusterVersionRequest updateClusterVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateClusterVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateClusterVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateClusterVersionRequestProtocolMarshaller(protocolFactory).marshall((UpdateClusterVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateClusterVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateClusterVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateClusterVersionResult updateClusterVersionResult = (UpdateClusterVersionResult)response.getAwsResponse();
            return updateClusterVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNodegroupConfigResult updateNodegroupConfig(UpdateNodegroupConfigRequest request) {
        request = (UpdateNodegroupConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateNodegroupConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNodegroupConfigResult executeUpdateNodegroupConfig(UpdateNodegroupConfigRequest updateNodegroupConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNodegroupConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNodegroupConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNodegroupConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateNodegroupConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNodegroupConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNodegroupConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNodegroupConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNodegroupConfigResult updateNodegroupConfigResult = (UpdateNodegroupConfigResult)response.getAwsResponse();
            return updateNodegroupConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNodegroupVersionResult updateNodegroupVersion(UpdateNodegroupVersionRequest request) {
        request = (UpdateNodegroupVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateNodegroupVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNodegroupVersionResult executeUpdateNodegroupVersion(UpdateNodegroupVersionRequest updateNodegroupVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNodegroupVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNodegroupVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNodegroupVersionRequestProtocolMarshaller(protocolFactory).marshall((UpdateNodegroupVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNodegroupVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EKS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNodegroupVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNodegroupVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNodegroupVersionResult updateNodegroupVersionResult = (UpdateNodegroupVersionResult)response.getAwsResponse();
            return updateNodegroupVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonEKSWaiters waiters() {
        if (this.waiters == null) {
            AmazonEKSClient amazonEKSClient = this;
            synchronized (amazonEKSClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonEKSWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

