/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.emrcontainers.AmazonEMRContainersAsync;
import com.amazonaws.services.emrcontainers.AmazonEMRContainersAsyncClientBuilder;
import com.amazonaws.services.emrcontainers.AmazonEMRContainersClient;
import com.amazonaws.services.emrcontainers.model.CancelJobRunRequest;
import com.amazonaws.services.emrcontainers.model.CancelJobRunResult;
import com.amazonaws.services.emrcontainers.model.CreateJobTemplateRequest;
import com.amazonaws.services.emrcontainers.model.CreateJobTemplateResult;
import com.amazonaws.services.emrcontainers.model.CreateManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.CreateManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.CreateVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.CreateVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.DeleteJobTemplateRequest;
import com.amazonaws.services.emrcontainers.model.DeleteJobTemplateResult;
import com.amazonaws.services.emrcontainers.model.DeleteManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.DeleteManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.DeleteVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.DeleteVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.DescribeJobRunRequest;
import com.amazonaws.services.emrcontainers.model.DescribeJobRunResult;
import com.amazonaws.services.emrcontainers.model.DescribeJobTemplateRequest;
import com.amazonaws.services.emrcontainers.model.DescribeJobTemplateResult;
import com.amazonaws.services.emrcontainers.model.DescribeManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.DescribeManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.DescribeVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.DescribeVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.GetManagedEndpointSessionCredentialsRequest;
import com.amazonaws.services.emrcontainers.model.GetManagedEndpointSessionCredentialsResult;
import com.amazonaws.services.emrcontainers.model.ListJobRunsRequest;
import com.amazonaws.services.emrcontainers.model.ListJobRunsResult;
import com.amazonaws.services.emrcontainers.model.ListJobTemplatesRequest;
import com.amazonaws.services.emrcontainers.model.ListJobTemplatesResult;
import com.amazonaws.services.emrcontainers.model.ListManagedEndpointsRequest;
import com.amazonaws.services.emrcontainers.model.ListManagedEndpointsResult;
import com.amazonaws.services.emrcontainers.model.ListTagsForResourceRequest;
import com.amazonaws.services.emrcontainers.model.ListTagsForResourceResult;
import com.amazonaws.services.emrcontainers.model.ListVirtualClustersRequest;
import com.amazonaws.services.emrcontainers.model.ListVirtualClustersResult;
import com.amazonaws.services.emrcontainers.model.StartJobRunRequest;
import com.amazonaws.services.emrcontainers.model.StartJobRunResult;
import com.amazonaws.services.emrcontainers.model.TagResourceRequest;
import com.amazonaws.services.emrcontainers.model.TagResourceResult;
import com.amazonaws.services.emrcontainers.model.UntagResourceRequest;
import com.amazonaws.services.emrcontainers.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEMRContainersAsyncClient
extends AmazonEMRContainersClient
implements AmazonEMRContainersAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEMRContainersAsyncClientBuilder asyncBuilder() {
        return AmazonEMRContainersAsyncClientBuilder.standard();
    }

    AmazonEMRContainersAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonEMRContainersAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobRunResult> cancelJobRunAsync(CancelJobRunRequest request) {
        return this.cancelJobRunAsync(request, null);
    }

    @Override
    public Future<CancelJobRunResult> cancelJobRunAsync(CancelJobRunRequest request, final AsyncHandler<CancelJobRunRequest, CancelJobRunResult> asyncHandler) {
        final CancelJobRunRequest finalRequest = (CancelJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobRunResult>(){

            @Override
            public CancelJobRunResult call() throws Exception {
                CancelJobRunResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeCancelJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobTemplateResult> createJobTemplateAsync(CreateJobTemplateRequest request) {
        return this.createJobTemplateAsync(request, null);
    }

    @Override
    public Future<CreateJobTemplateResult> createJobTemplateAsync(CreateJobTemplateRequest request, final AsyncHandler<CreateJobTemplateRequest, CreateJobTemplateResult> asyncHandler) {
        final CreateJobTemplateRequest finalRequest = (CreateJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobTemplateResult>(){

            @Override
            public CreateJobTemplateResult call() throws Exception {
                CreateJobTemplateResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeCreateJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateManagedEndpointResult> createManagedEndpointAsync(CreateManagedEndpointRequest request) {
        return this.createManagedEndpointAsync(request, null);
    }

    @Override
    public Future<CreateManagedEndpointResult> createManagedEndpointAsync(CreateManagedEndpointRequest request, final AsyncHandler<CreateManagedEndpointRequest, CreateManagedEndpointResult> asyncHandler) {
        final CreateManagedEndpointRequest finalRequest = (CreateManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateManagedEndpointResult>(){

            @Override
            public CreateManagedEndpointResult call() throws Exception {
                CreateManagedEndpointResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeCreateManagedEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVirtualClusterResult> createVirtualClusterAsync(CreateVirtualClusterRequest request) {
        return this.createVirtualClusterAsync(request, null);
    }

    @Override
    public Future<CreateVirtualClusterResult> createVirtualClusterAsync(CreateVirtualClusterRequest request, final AsyncHandler<CreateVirtualClusterRequest, CreateVirtualClusterResult> asyncHandler) {
        final CreateVirtualClusterRequest finalRequest = (CreateVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVirtualClusterResult>(){

            @Override
            public CreateVirtualClusterResult call() throws Exception {
                CreateVirtualClusterResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeCreateVirtualCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobTemplateResult> deleteJobTemplateAsync(DeleteJobTemplateRequest request) {
        return this.deleteJobTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteJobTemplateResult> deleteJobTemplateAsync(DeleteJobTemplateRequest request, final AsyncHandler<DeleteJobTemplateRequest, DeleteJobTemplateResult> asyncHandler) {
        final DeleteJobTemplateRequest finalRequest = (DeleteJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteJobTemplateResult>(){

            @Override
            public DeleteJobTemplateResult call() throws Exception {
                DeleteJobTemplateResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDeleteJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteManagedEndpointResult> deleteManagedEndpointAsync(DeleteManagedEndpointRequest request) {
        return this.deleteManagedEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteManagedEndpointResult> deleteManagedEndpointAsync(DeleteManagedEndpointRequest request, final AsyncHandler<DeleteManagedEndpointRequest, DeleteManagedEndpointResult> asyncHandler) {
        final DeleteManagedEndpointRequest finalRequest = (DeleteManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteManagedEndpointResult>(){

            @Override
            public DeleteManagedEndpointResult call() throws Exception {
                DeleteManagedEndpointResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDeleteManagedEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualClusterResult> deleteVirtualClusterAsync(DeleteVirtualClusterRequest request) {
        return this.deleteVirtualClusterAsync(request, null);
    }

    @Override
    public Future<DeleteVirtualClusterResult> deleteVirtualClusterAsync(DeleteVirtualClusterRequest request, final AsyncHandler<DeleteVirtualClusterRequest, DeleteVirtualClusterResult> asyncHandler) {
        final DeleteVirtualClusterRequest finalRequest = (DeleteVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVirtualClusterResult>(){

            @Override
            public DeleteVirtualClusterResult call() throws Exception {
                DeleteVirtualClusterResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDeleteVirtualCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobRunResult> describeJobRunAsync(DescribeJobRunRequest request) {
        return this.describeJobRunAsync(request, null);
    }

    @Override
    public Future<DescribeJobRunResult> describeJobRunAsync(DescribeJobRunRequest request, final AsyncHandler<DescribeJobRunRequest, DescribeJobRunResult> asyncHandler) {
        final DescribeJobRunRequest finalRequest = (DescribeJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobRunResult>(){

            @Override
            public DescribeJobRunResult call() throws Exception {
                DescribeJobRunResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDescribeJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobTemplateResult> describeJobTemplateAsync(DescribeJobTemplateRequest request) {
        return this.describeJobTemplateAsync(request, null);
    }

    @Override
    public Future<DescribeJobTemplateResult> describeJobTemplateAsync(DescribeJobTemplateRequest request, final AsyncHandler<DescribeJobTemplateRequest, DescribeJobTemplateResult> asyncHandler) {
        final DescribeJobTemplateRequest finalRequest = (DescribeJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobTemplateResult>(){

            @Override
            public DescribeJobTemplateResult call() throws Exception {
                DescribeJobTemplateResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDescribeJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeManagedEndpointResult> describeManagedEndpointAsync(DescribeManagedEndpointRequest request) {
        return this.describeManagedEndpointAsync(request, null);
    }

    @Override
    public Future<DescribeManagedEndpointResult> describeManagedEndpointAsync(DescribeManagedEndpointRequest request, final AsyncHandler<DescribeManagedEndpointRequest, DescribeManagedEndpointResult> asyncHandler) {
        final DescribeManagedEndpointRequest finalRequest = (DescribeManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeManagedEndpointResult>(){

            @Override
            public DescribeManagedEndpointResult call() throws Exception {
                DescribeManagedEndpointResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDescribeManagedEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualClusterResult> describeVirtualClusterAsync(DescribeVirtualClusterRequest request) {
        return this.describeVirtualClusterAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualClusterResult> describeVirtualClusterAsync(DescribeVirtualClusterRequest request, final AsyncHandler<DescribeVirtualClusterRequest, DescribeVirtualClusterResult> asyncHandler) {
        final DescribeVirtualClusterRequest finalRequest = (DescribeVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVirtualClusterResult>(){

            @Override
            public DescribeVirtualClusterResult call() throws Exception {
                DescribeVirtualClusterResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeDescribeVirtualCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetManagedEndpointSessionCredentialsResult> getManagedEndpointSessionCredentialsAsync(GetManagedEndpointSessionCredentialsRequest request) {
        return this.getManagedEndpointSessionCredentialsAsync(request, null);
    }

    @Override
    public Future<GetManagedEndpointSessionCredentialsResult> getManagedEndpointSessionCredentialsAsync(GetManagedEndpointSessionCredentialsRequest request, final AsyncHandler<GetManagedEndpointSessionCredentialsRequest, GetManagedEndpointSessionCredentialsResult> asyncHandler) {
        final GetManagedEndpointSessionCredentialsRequest finalRequest = (GetManagedEndpointSessionCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetManagedEndpointSessionCredentialsResult>(){

            @Override
            public GetManagedEndpointSessionCredentialsResult call() throws Exception {
                GetManagedEndpointSessionCredentialsResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeGetManagedEndpointSessionCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobRunsResult> listJobRunsAsync(ListJobRunsRequest request) {
        return this.listJobRunsAsync(request, null);
    }

    @Override
    public Future<ListJobRunsResult> listJobRunsAsync(ListJobRunsRequest request, final AsyncHandler<ListJobRunsRequest, ListJobRunsResult> asyncHandler) {
        final ListJobRunsRequest finalRequest = (ListJobRunsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobRunsResult>(){

            @Override
            public ListJobRunsResult call() throws Exception {
                ListJobRunsResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeListJobRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobTemplatesResult> listJobTemplatesAsync(ListJobTemplatesRequest request) {
        return this.listJobTemplatesAsync(request, null);
    }

    @Override
    public Future<ListJobTemplatesResult> listJobTemplatesAsync(ListJobTemplatesRequest request, final AsyncHandler<ListJobTemplatesRequest, ListJobTemplatesResult> asyncHandler) {
        final ListJobTemplatesRequest finalRequest = (ListJobTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobTemplatesResult>(){

            @Override
            public ListJobTemplatesResult call() throws Exception {
                ListJobTemplatesResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeListJobTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListManagedEndpointsResult> listManagedEndpointsAsync(ListManagedEndpointsRequest request) {
        return this.listManagedEndpointsAsync(request, null);
    }

    @Override
    public Future<ListManagedEndpointsResult> listManagedEndpointsAsync(ListManagedEndpointsRequest request, final AsyncHandler<ListManagedEndpointsRequest, ListManagedEndpointsResult> asyncHandler) {
        final ListManagedEndpointsRequest finalRequest = (ListManagedEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListManagedEndpointsResult>(){

            @Override
            public ListManagedEndpointsResult call() throws Exception {
                ListManagedEndpointsResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeListManagedEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVirtualClustersResult> listVirtualClustersAsync(ListVirtualClustersRequest request) {
        return this.listVirtualClustersAsync(request, null);
    }

    @Override
    public Future<ListVirtualClustersResult> listVirtualClustersAsync(ListVirtualClustersRequest request, final AsyncHandler<ListVirtualClustersRequest, ListVirtualClustersResult> asyncHandler) {
        final ListVirtualClustersRequest finalRequest = (ListVirtualClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVirtualClustersResult>(){

            @Override
            public ListVirtualClustersResult call() throws Exception {
                ListVirtualClustersResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeListVirtualClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartJobRunResult> startJobRunAsync(StartJobRunRequest request) {
        return this.startJobRunAsync(request, null);
    }

    @Override
    public Future<StartJobRunResult> startJobRunAsync(StartJobRunRequest request, final AsyncHandler<StartJobRunRequest, StartJobRunResult> asyncHandler) {
        final StartJobRunRequest finalRequest = (StartJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartJobRunResult>(){

            @Override
            public StartJobRunResult call() throws Exception {
                StartJobRunResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeStartJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonEMRContainersAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

