/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fms.model.ExpectedRoute;
import java.util.List;

@SdkInternalApi
public class ExpectedRouteMarshaller {
    private static final MarshallingInfo<String> IPV4CIDR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpV4Cidr").build();
    private static final MarshallingInfo<String> PREFIXLISTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrefixListId").build();
    private static final MarshallingInfo<String> IPV6CIDR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpV6Cidr").build();
    private static final MarshallingInfo<List> CONTRIBUTINGSUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContributingSubnets").build();
    private static final MarshallingInfo<List> ALLOWEDTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedTargets").build();
    private static final MarshallingInfo<String> ROUTETABLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RouteTableId").build();
    private static final ExpectedRouteMarshaller instance = new ExpectedRouteMarshaller();

    public static ExpectedRouteMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExpectedRoute expectedRoute, ProtocolMarshaller protocolMarshaller) {
        if (expectedRoute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)expectedRoute.getIpV4Cidr(), IPV4CIDR_BINDING);
            protocolMarshaller.marshall((Object)expectedRoute.getPrefixListId(), PREFIXLISTID_BINDING);
            protocolMarshaller.marshall((Object)expectedRoute.getIpV6Cidr(), IPV6CIDR_BINDING);
            protocolMarshaller.marshall(expectedRoute.getContributingSubnets(), CONTRIBUTINGSUBNETS_BINDING);
            protocolMarshaller.marshall(expectedRoute.getAllowedTargets(), ALLOWEDTARGETS_BINDING);
            protocolMarshaller.marshall((Object)expectedRoute.getRouteTableId(), ROUTETABLEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

