/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecastquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecastquery.model.DataPoint;
import com.amazonaws.services.forecastquery.model.transform.ForecastMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Forecast
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, List<DataPoint>> predictions;

    public Map<String, List<DataPoint>> getPredictions() {
        return this.predictions;
    }

    public void setPredictions(Map<String, List<DataPoint>> predictions) {
        this.predictions = predictions;
    }

    public Forecast withPredictions(Map<String, List<DataPoint>> predictions) {
        this.setPredictions(predictions);
        return this;
    }

    public Forecast addPredictionsEntry(String key, List<DataPoint> value) {
        if (null == this.predictions) {
            this.predictions = new HashMap<String, List<DataPoint>>();
        }
        if (this.predictions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.predictions.put(key, value);
        return this;
    }

    public Forecast clearPredictionsEntries() {
        this.predictions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictions() != null) {
            sb.append("Predictions: ").append(this.getPredictions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Forecast)) {
            return false;
        }
        Forecast other = (Forecast)obj;
        if (other.getPredictions() == null ^ this.getPredictions() == null) {
            return false;
        }
        return other.getPredictions() == null || other.getPredictions().equals(this.getPredictions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictions() == null ? 0 : this.getPredictions().hashCode());
        return hashCode;
    }

    public Forecast clone() {
        try {
            return (Forecast)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ForecastMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

