/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.PolicyVersion;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPolicyVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<PolicyVersion> versions;
    private Boolean isTruncated;
    private String marker;

    public List<PolicyVersion> getVersions() {
        if (this.versions == null) {
            this.versions = new SdkInternalList();
        }
        return this.versions;
    }

    public void setVersions(Collection<PolicyVersion> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new SdkInternalList(versions);
    }

    public ListPolicyVersionsResult withVersions(PolicyVersion ... versions) {
        if (this.versions == null) {
            this.setVersions((Collection<PolicyVersion>)new SdkInternalList(versions.length));
        }
        for (PolicyVersion ele : versions) {
            this.versions.add((Object)ele);
        }
        return this;
    }

    public ListPolicyVersionsResult withVersions(Collection<PolicyVersion> versions) {
        this.setVersions(versions);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListPolicyVersionsResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListPolicyVersionsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions()).append(",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: ").append(this.getIsTruncated()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResult)) {
            return false;
        }
        ListPolicyVersionsResult other = (ListPolicyVersionsResult)obj;
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        if (other.getIsTruncated() != null && !other.getIsTruncated().equals(this.getIsTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListPolicyVersionsResult clone() {
        try {
            return (ListPolicyVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

