/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.Range;
import com.amazonaws.services.macie2.model.transform.PageMarshaller;
import java.io.Serializable;

public class Page
implements Serializable,
Cloneable,
StructuredPojo {
    private Range lineRange;
    private Range offsetRange;
    private Long pageNumber;

    public void setLineRange(Range lineRange) {
        this.lineRange = lineRange;
    }

    public Range getLineRange() {
        return this.lineRange;
    }

    public Page withLineRange(Range lineRange) {
        this.setLineRange(lineRange);
        return this;
    }

    public void setOffsetRange(Range offsetRange) {
        this.offsetRange = offsetRange;
    }

    public Range getOffsetRange() {
        return this.offsetRange;
    }

    public Page withOffsetRange(Range offsetRange) {
        this.setOffsetRange(offsetRange);
        return this;
    }

    public void setPageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Page withPageNumber(Long pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLineRange() != null) {
            sb.append("LineRange: ").append(this.getLineRange()).append(",");
        }
        if (this.getOffsetRange() != null) {
            sb.append("OffsetRange: ").append(this.getOffsetRange()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        if (other.getLineRange() == null ^ this.getLineRange() == null) {
            return false;
        }
        if (other.getLineRange() != null && !other.getLineRange().equals(this.getLineRange())) {
            return false;
        }
        if (other.getOffsetRange() == null ^ this.getOffsetRange() == null) {
            return false;
        }
        if (other.getOffsetRange() != null && !other.getOffsetRange().equals(this.getOffsetRange())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        return other.getPageNumber() == null || other.getPageNumber().equals(this.getPageNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLineRange() == null ? 0 : this.getLineRange().hashCode());
        hashCode = 31 * hashCode + (this.getOffsetRange() == null ? 0 : this.getOffsetRange().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        return hashCode;
    }

    public Page clone() {
        try {
            return (Page)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

