/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.personalize.model.DatasetGroup;
import java.util.Date;

@SdkInternalApi
public class DatasetGroupMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetGroupArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyArn").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").build();
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domain").build();
    private static final DatasetGroupMarshaller instance = new DatasetGroupMarshaller();

    public static DatasetGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetGroup datasetGroup, ProtocolMarshaller protocolMarshaller) {
        if (datasetGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datasetGroup.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getKmsKeyArn(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)datasetGroup.getDomain(), DOMAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

