/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.private5g.model.Order;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class OrderMarshaller {
    private static final MarshallingInfo<String> ACKNOWLEDGMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acknowledgmentStatus").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> NETWORKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkArn").build();
    private static final MarshallingInfo<String> NETWORKSITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkSiteArn").build();
    private static final MarshallingInfo<String> ORDERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("orderArn").build();
    private static final MarshallingInfo<List> ORDEREDRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("orderedResources").build();
    private static final MarshallingInfo<StructuredPojo> SHIPPINGADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shippingAddress").build();
    private static final MarshallingInfo<List> TRACKINGINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trackingInformation").build();
    private static final OrderMarshaller instance = new OrderMarshaller();

    public static OrderMarshaller getInstance() {
        return instance;
    }

    public void marshall(Order order, ProtocolMarshaller protocolMarshaller) {
        if (order == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)order.getAcknowledgmentStatus(), ACKNOWLEDGMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)order.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)order.getNetworkArn(), NETWORKARN_BINDING);
            protocolMarshaller.marshall((Object)order.getNetworkSiteArn(), NETWORKSITEARN_BINDING);
            protocolMarshaller.marshall((Object)order.getOrderArn(), ORDERARN_BINDING);
            protocolMarshaller.marshall(order.getOrderedResources(), ORDEREDRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)order.getShippingAddress(), SHIPPINGADDRESS_BINDING);
            protocolMarshaller.marshall(order.getTrackingInformation(), TRACKINGINFORMATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

