/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SnapshotFileFormatType;
import com.amazonaws.services.quicksight.model.SnapshotFileSheetSelection;
import com.amazonaws.services.quicksight.model.transform.SnapshotFileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnapshotFile
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SnapshotFileSheetSelection> sheetSelections;
    private String formatType;

    public List<SnapshotFileSheetSelection> getSheetSelections() {
        return this.sheetSelections;
    }

    public void setSheetSelections(Collection<SnapshotFileSheetSelection> sheetSelections) {
        if (sheetSelections == null) {
            this.sheetSelections = null;
            return;
        }
        this.sheetSelections = new ArrayList<SnapshotFileSheetSelection>(sheetSelections);
    }

    public SnapshotFile withSheetSelections(SnapshotFileSheetSelection ... sheetSelections) {
        if (this.sheetSelections == null) {
            this.setSheetSelections(new ArrayList<SnapshotFileSheetSelection>(sheetSelections.length));
        }
        for (SnapshotFileSheetSelection ele : sheetSelections) {
            this.sheetSelections.add(ele);
        }
        return this;
    }

    public SnapshotFile withSheetSelections(Collection<SnapshotFileSheetSelection> sheetSelections) {
        this.setSheetSelections(sheetSelections);
        return this;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public SnapshotFile withFormatType(String formatType) {
        this.setFormatType(formatType);
        return this;
    }

    public SnapshotFile withFormatType(SnapshotFileFormatType formatType) {
        this.formatType = formatType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSheetSelections() != null) {
            sb.append("SheetSelections: ").append(this.getSheetSelections()).append(",");
        }
        if (this.getFormatType() != null) {
            sb.append("FormatType: ").append(this.getFormatType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFile)) {
            return false;
        }
        SnapshotFile other = (SnapshotFile)obj;
        if (other.getSheetSelections() == null ^ this.getSheetSelections() == null) {
            return false;
        }
        if (other.getSheetSelections() != null && !other.getSheetSelections().equals(this.getSheetSelections())) {
            return false;
        }
        if (other.getFormatType() == null ^ this.getFormatType() == null) {
            return false;
        }
        return other.getFormatType() == null || other.getFormatType().equals(this.getFormatType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSheetSelections() == null ? 0 : this.getSheetSelections().hashCode());
        hashCode = 31 * hashCode + (this.getFormatType() == null ? 0 : this.getFormatType().hashCode());
        return hashCode;
    }

    public SnapshotFile clone() {
        try {
            return (SnapshotFile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotFileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

