/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.ItemSource;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ItemSourceMarshaller {
    private static final MarshallingInfo<Map> ASSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Assets").build();
    private static final MarshallingInfo<Date> DATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> GEOMETRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Geometry").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<StructuredPojo> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").build();
    private static final ItemSourceMarshaller instance = new ItemSourceMarshaller();

    public static ItemSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ItemSource itemSource, ProtocolMarshaller protocolMarshaller) {
        if (itemSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(itemSource.getAssets(), ASSETS_BINDING);
            protocolMarshaller.marshall((Object)itemSource.getDateTime(), DATETIME_BINDING);
            protocolMarshaller.marshall((Object)itemSource.getGeometry(), GEOMETRY_BINDING);
            protocolMarshaller.marshall((Object)itemSource.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)itemSource.getProperties(), PROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

