/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.PropertyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyUtils {
    public static Set<Class> getAllImplementedInterfaces(Class clazz) {
        Set<Class> ret = null;
        ret = clazz.getSuperclass() != null ? PropertyUtils.getAllImplementedInterfaces(clazz.getSuperclass()) : new HashSet<Class>();
        Class<?>[] interfaces = clazz.getInterfaces();
        ret.addAll(Arrays.asList(interfaces));
        return ret;
    }

    public static void setProperty(Object target, String propertyName, Object propertyValue) throws PropertyException {
        String[] propertyNames = propertyName.split("\\.");
        Object currentTarget = target;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            String name = propertyNames[i];
            Object result = PropertyUtils.callGetter(currentTarget, name);
            if (result == null) {
                Class propertyType = PropertyUtils.getPropertyType(target, name);
                try {
                    result = propertyType.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
                }
                PropertyUtils.callSetter(currentTarget, name, result);
            }
            currentTarget = result;
        }
        String lastPropertyName = propertyNames[propertyNames.length - 1];
        if (currentTarget instanceof Properties) {
            Properties p = (Properties)currentTarget;
            p.setProperty(lastPropertyName, propertyValue.toString());
        } else {
            PropertyUtils.setDirectProperty(currentTarget, lastPropertyName, propertyValue);
        }
    }

    public static Map getProperties(Object target) throws PropertyException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Class<?> clazz = target.getClass();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (method.getModifiers() != 1 || method.getParameterTypes().length != 0 || !name.startsWith("get") && !name.startsWith("is") || !PropertyUtils.containsSetterForGetter(clazz, method)) continue;
            String propertyName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            try {
                Object propertyValue = method.invoke(target, (Object[])null);
                if (propertyValue != null && propertyValue instanceof Properties) {
                    Map propertiesContent = PropertyUtils.getNestedProperties(propertyName, (Properties)propertyValue);
                    properties.putAll(propertiesContent);
                    continue;
                }
                properties.put(propertyName, propertyValue);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
            }
            catch (InvocationTargetException ex) {
                throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
            }
        }
        return properties;
    }

    public static Object getProperty(Object target, String propertyName) throws PropertyException {
        String[] propertyNames = propertyName.split("\\.");
        Object currentTarget = target;
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            Object result = PropertyUtils.callGetter(currentTarget, name);
            if (result == null && i < propertyNames.length - 1) {
                throw new PropertyException("cannot get property '" + propertyName + "' - '" + name + "' is null");
            }
            currentTarget = result;
        }
        return currentTarget;
    }

    public static void setProperties(Object target, Map properties) throws PropertyException {
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            PropertyUtils.setProperty(target, name, value);
        }
    }

    private static void setDirectProperty(Object target, String propertyName, Object propertyValue) throws PropertyException {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        Class<?> parameterType = setter.getParameterTypes()[0];
        try {
            if (propertyValue != null) {
                Object transformedPropertyValue = PropertyUtils.convert(propertyValue, parameterType);
                setter.invoke(target, transformedPropertyValue);
            } else {
                setter.invoke(target, new Object[]{null});
            }
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Map getNestedProperties(String prefix, Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            result.put(prefix + '.' + name, value);
        }
        return result;
    }

    private static Object convert(Object value, Class destinationClass) throws PropertyException {
        if (value.getClass() == destinationClass) {
            return value;
        }
        if (value.getClass() == Integer.TYPE || value.getClass() == Integer.class || value.getClass() == Boolean.TYPE || value.getClass() == Boolean.class) {
            return value;
        }
        if ((destinationClass == Integer.TYPE || destinationClass == Integer.class) && value.getClass() == String.class) {
            return new Integer((String)value);
        }
        if ((destinationClass == Boolean.TYPE || destinationClass == Boolean.class) && value.getClass() == String.class) {
            return Boolean.valueOf((String)value);
        }
        if ((destinationClass == Short.TYPE || destinationClass == Short.class) && value.getClass() == String.class) {
            return new Short((String)value);
        }
        throw new PropertyException("cannot convert values of type '" + value.getClass().getName() + "' into type '" + destinationClass + "'");
    }

    private static void callSetter(Object target, String propertyName, Object parameter) throws PropertyException {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Object callGetter(Object target, String propertyName) throws PropertyException {
        Method getter = PropertyUtils.getGetter(target, propertyName);
        try {
            return getter.invoke(target, (Object[])null);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Method getSetter(Object target, String propertyName) throws PropertyException {
        if (propertyName == null || "".equals(propertyName)) {
            throw new PropertyException("encountered invalid null or empty property name");
        }
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(setterName) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new PropertyException("no writeable property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }

    private static Method getGetter(Object target, String propertyName) throws PropertyException {
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(getterName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        throw new PropertyException("no readable property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }

    private static boolean containsSetterForGetter(Class clazz, Method getterMethod) throws PropertyException {
        String setterMethodName;
        String getterMethodName = getterMethod.getName();
        if (getterMethodName.startsWith("get")) {
            setterMethodName = "set" + getterMethodName.substring(3);
        } else if (getterMethodName.startsWith("is")) {
            setterMethodName = "set" + getterMethodName.substring(2);
        } else {
            throw new PropertyException("method '" + getterMethodName + "' is not a getter, no setter can be found");
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(setterMethodName)) continue;
            return true;
        }
        return false;
    }

    private static Class getPropertyType(Object target, String propertyName) throws PropertyException {
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(getterName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method.getReturnType();
        }
        throw new PropertyException("no property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }
}

