/*
 * Decompiled with CFR 0.152.
 */
package com.avides.springboot.testcontainer.common.cleanup;

import com.avides.springboot.testcontainer.common.cleanup.ContainerCleanupProperties;
import com.avides.springboot.testcontainer.common.util.IssuerUtil;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientBuilder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"embedded.container.cleanup.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ContainerCleanupProperties.class})
public class EmbeddedContainerCleanupAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedContainerCleanupAutoConfiguration.class);

    @ConditionalOnMissingBean(value={EmbeddedContainerCleanup.class})
    @Bean
    public EmbeddedContainerCleanup embeddedContainerCleanup(ContainerCleanupProperties properties) {
        return new EmbeddedContainerCleanup(properties);
    }

    public class EmbeddedContainerCleanup {
        public EmbeddedContainerCleanup(ContainerCleanupProperties properties) {
            log.info("{} stale containers removed", (Object)this.removeStaleContainers(properties));
        }

        private int removeStaleContainers(ContainerCleanupProperties properties) {
            String currentIssuer = IssuerUtil.getIssuer();
            ArrayList<Container> issuerContainers = new ArrayList<Container>();
            ArrayList<Container> staleContainers = new ArrayList<Container>();
            try (DockerClient dockerClient = DockerClientBuilder.getInstance().build();){
                for (Container container : (List)dockerClient.listContainersCmd().exec()) {
                    LocalDateTime staleSince;
                    if (!container.getLabels().containsKey("TESTCONTAINER_STARTED")) continue;
                    long millis = Long.parseLong((String)container.getLabels().get("TESTCONTAINER_STARTED"));
                    LocalDateTime started = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
                    if (started.isBefore(staleSince = LocalDateTime.now().minusMinutes(properties.getAfterMinutes()))) {
                        staleContainers.add(container);
                        continue;
                    }
                    if (!currentIssuer.equals(container.getLabels().get("TESTCONTAINER_ISSUER"))) continue;
                    issuerContainers.add(container);
                }
                if (issuerContainers.size() > properties.getMaxConcurrentPerIssuer()) {
                    staleContainers.addAll(issuerContainers);
                    log.warn("Too much concurrent containers ({}) for issuer \"{}\"", (Object)issuerContainers.size(), (Object)currentIssuer);
                }
                for (Container staleContainer : staleContainers) {
                    dockerClient.removeContainerCmd(staleContainer.getId()).withForce(Boolean.TRUE).withRemoveVolumes(Boolean.TRUE).exec();
                    log.warn("Stale container removed ({})", (Object)staleContainer.labels);
                }
            }
            return staleContainers.size();
        }

        public EmbeddedContainerCleanup() {
        }
    }
}

