/*
 * Decompiled with CFR 0.152.
 */
package com.avides.springboot.testcontainer.common.container;

import com.avides.springboot.testcontainer.common.container.AbstractEmbeddedContainer;
import com.avides.springboot.testcontainer.common.container.AbstractEmbeddedContainerProperties;
import com.avides.springboot.testcontainer.common.container.ContainerStartupFailedException;
import com.avides.springboot.testcontainer.common.util.IssuerUtil;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class AbstractBuildingEmbeddedContainer<P extends AbstractEmbeddedContainerProperties>
extends AbstractEmbeddedContainer<P>
implements ApplicationListener<ApplicationContextEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBuildingEmbeddedContainer.class);
    protected String service;

    public AbstractBuildingEmbeddedContainer(String service, ConfigurableEnvironment environment, P properties) {
        block18: {
            this.service = service;
            this.environment = environment;
            this.properties = properties;
            log.info("Starting {}-container with {}", (Object)service, properties);
            try (DockerClient dockerClient = DockerClientBuilder.getInstance().build();){
                this.createContainer(dockerClient);
                log.info("Checking {}-container... (Timeout: {}s)", (Object)service, (Object)((AbstractEmbeddedContainerProperties)properties).getStartupTimeout());
                long startupDuration = this.waitUntilReady(properties);
                log.info("{}-container started (Duration: {}ms, Host: {})", new Object[]{service, startupDuration, this.getContainerHost()});
                environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("embedded" + service + "Properties", this.providedProperties()));
            }
            catch (NotFoundException e) {
                if (e.getMessage().contains("No such image")) {
                    log.error("Image not found ({})", (Object)((AbstractEmbeddedContainerProperties)properties).getDockerImage());
                    break block18;
                }
                log.error("Unknown error pulling image", (Throwable)e);
            }
            catch (ContainerStartupFailedException e) {
                this.killContainer(DockerClientBuilder.getInstance().build());
                log.error("Failed to start {}-container", (Object)service, (Object)e);
            }
        }
    }

    protected List<String> getEnvs() {
        return new ArrayList<String>();
    }

    protected Map<String, String> getLabels() {
        return new HashMap<String, String>();
    }

    protected List<String> getTmpDirectories() {
        return new ArrayList<String>();
    }

    private Map<String, String> getTestcontainerLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("TESTCONTAINER_SERVICE", this.service);
        labels.put("TESTCONTAINER_IMAGE", this.properties.getDockerImage());
        labels.put("TESTCONTAINER_STARTED", String.valueOf(System.currentTimeMillis()));
        labels.put("TESTCONTAINER_ISSUER", IssuerUtil.getIssuer());
        return labels;
    }

    private Map<String, String> getAllLabels() {
        Map<String, String> labels = this.getLabels();
        labels.putAll(this.getTestcontainerLabels());
        return labels;
    }

    protected HostConfig buildHostConfig() {
        HostConfig hostConfig = new HostConfig();
        hostConfig.withPublishAllPorts(Boolean.TRUE);
        if (!this.getTmpDirectories().isEmpty()) {
            HashMap tmpDirectories = new HashMap();
            this.getTmpDirectories().forEach(directory -> tmpDirectories.put(directory, ""));
            hostConfig.withTmpFs(tmpDirectories);
        }
        return hostConfig;
    }

    protected void createContainer(DockerClient dockerClient) throws InterruptedException {
        this.pullImage(dockerClient);
        CreateContainerCmd createContainerCmd = dockerClient.createContainerCmd(this.properties.getDockerImage()).withLabels(this.getAllLabels()).withEnv(this.getEnvs()).withHostConfig(this.buildHostConfig());
        this.adjustCreateCommand(createContainerCmd);
        String containerId = createContainerCmd.exec().getId();
        dockerClient.startContainerCmd(containerId).exec();
        this.containerInfo = dockerClient.inspectContainerCmd(containerId).exec();
    }

    protected void adjustCreateCommand(CreateContainerCmd createContainerCmd) {
    }

    protected void pullImage(DockerClient dockerClient) throws InterruptedException {
        try {
            try {
                dockerClient.inspectImageCmd(this.properties.getDockerImage()).exec();
            }
            catch (NotFoundException e) {
                ((PullImageResultCallback)dockerClient.pullImageCmd(this.properties.getDockerImage()).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
            }
        }
        catch (InternalServerErrorException e) {
            log.warn("Failed to pull image from registry. Try to proceed with local image..", (Throwable)e);
        }
    }

    protected Map<String, Object> providedProperties() {
        return new HashMap<String, Object>();
    }

    protected long waitUntilReady(P properties) throws ContainerStartupFailedException {
        try {
            long started = System.currentTimeMillis();
            Unreliables.retryUntilTrue((int)((AbstractEmbeddedContainerProperties)properties).getStartupTimeout(), (TimeUnit)TimeUnit.SECONDS, () -> this.isContainerReady(properties));
            return System.currentTimeMillis() - started;
        }
        catch (TimeoutException e) {
            throw new ContainerStartupFailedException(e);
        }
    }

    protected abstract boolean isContainerReady(P var1);

    public void onApplicationEvent(ApplicationContextEvent event) {
        block16: {
            if (!(event instanceof ContextStoppedEvent) && !(event instanceof ContextClosedEvent)) break block16;
            try (DockerClient dockerClient = DockerClientBuilder.getInstance().build();){
                log.info("Stopping {}-container...", (Object)this.service);
                this.killContainer(dockerClient);
                log.info("{}-container stopped", (Object)this.service);
            }
            catch (NotFoundException e) {
                log.info("{}-container not found.. ignored", (Object)this.service, (Object)e);
            }
        }
    }
}

