/*
 * Decompiled with CFR 0.152.
 */
package com.avides.springboot.testcontainer.common.container;

import com.avides.springboot.testcontainer.common.container.AbstractEmbeddedContainerProperties;
import com.avides.springboot.testcontainer.common.container.EmbeddedContainer;
import com.avides.springboot.testcontainer.common.util.OSUtils;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import java.lang.reflect.Field;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class AbstractEmbeddedContainer<P extends AbstractEmbeddedContainerProperties>
implements EmbeddedContainer {
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedContainer.class);
    protected ConfigurableEnvironment environment;
    protected P properties;
    protected InspectContainerResponse containerInfo;

    protected String getContainerHost() {
        if (StringUtils.isNotBlank((String)AbstractEmbeddedContainer.getDockerHost())) {
            return AbstractEmbeddedContainer.getDockerHost();
        }
        if (OSUtils.isMac()) {
            return "localhost";
        }
        String containerNetwork = this.environment.getProperty("embedded.container.container-network", "bridge");
        return ((ContainerNetwork)this.containerInfo.getNetworkSettings().getNetworks().get(containerNetwork)).getIpAddress();
    }

    private static String getDockerHost() {
        try {
            DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
            Field declaredField = builder.getClass().getDeclaredField("dockerHost");
            declaredField.setAccessible(true);
            return ((URI)declaredField.get(builder)).getHost();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn("Unable to resolve the dockerHost by the DefaultDockerClientConfig. Switching to env variables..", (Throwable)e);
            String dockerHostProperty = System.getProperty("DOCKER_HOST", System.getenv("DOCKER_HOST"));
            return StringUtils.isNotBlank((String)dockerHostProperty) ? new URI(dockerHostProperty).getHost() : null;
        }
    }

    protected int getContainerPort(int exposed) {
        if (StringUtils.isNotBlank((String)AbstractEmbeddedContainer.getDockerHost())) {
            return this.getMappedPort(exposed);
        }
        if (OSUtils.isMac()) {
            return this.getMappedPort(exposed);
        }
        return exposed;
    }

    private int getMappedPort(int exposed) {
        return Integer.parseInt(((Ports.Binding[])this.containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(exposed)))[0].getHostPortSpec());
    }

    protected void killContainer(DockerClient dockerClient) {
        dockerClient.removeContainerCmd(this.containerInfo.getId()).withForce(Boolean.TRUE).withRemoveVolumes(Boolean.TRUE).exec();
    }
}

