/*
 * Decompiled with CFR 0.152.
 */
package com.avides.springboot.testcontainer.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class IssuerUtil {
    private static final Pattern TARGET_PATTERN = Pattern.compile("(.*)(/|\\\\)(.*)(/|\\\\)target(/|\\\\)(.*)");

    public static String getIssuer() {
        Matcher matcher;
        Matcher matcher2;
        String jobName = System.getProperty("JENKINS_JOB_NAME");
        if (StringUtils.isNotBlank((String)jobName)) {
            return jobName;
        }
        String javaCommand = System.getProperty("sun.java.command");
        if (StringUtils.isNotBlank((String)javaCommand) && (matcher2 = TARGET_PATTERN.matcher(javaCommand.split(":")[0])).find()) {
            return matcher2.group(3);
        }
        String javaClassPath = System.getProperty("java.class.path");
        if (StringUtils.isNotBlank((String)javaClassPath) && (matcher = TARGET_PATTERN.matcher(javaClassPath.split(":")[0])).find()) {
            return matcher.group(3);
        }
        return "unknown";
    }

    private IssuerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String jobName = System.getenv("JOB_NAME");
        if (StringUtils.isNotBlank((String)jobName)) {
            System.setProperty("JENKINS_JOB_NAME", jobName);
        }
    }
}

