/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.ChatCompletionsAsyncClient;
import com.azure.ai.inference.ChatCompletionsClient;
import com.azure.ai.inference.ModelServiceVersion;
import com.azure.ai.inference.implementation.ChatCompletionsClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.KeyCredentialTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.KeyCredentialPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ChatCompletionsClient.class, ChatCompletionsAsyncClient.class})
public final class ChatCompletionsClientBuilder
implements HttpTrait<ChatCompletionsClientBuilder>,
ConfigurationTrait<ChatCompletionsClientBuilder>,
TokenCredentialTrait<ChatCompletionsClientBuilder>,
KeyCredentialTrait<ChatCompletionsClientBuilder>,
EndpointTrait<ChatCompletionsClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://ml.azure.com/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-ai-inference.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies;
    private String[] scopes = DEFAULT_SCOPES;
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private KeyCredential keyCredential;
    private String endpoint;
    private ModelServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(ChatCompletionsClientBuilder.class);

    public ChatCompletionsClientBuilder() {
        this.pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    }

    public ChatCompletionsClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ChatCompletionsClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ChatCompletionsClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public ChatCompletionsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ChatCompletionsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ChatCompletionsClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public ChatCompletionsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ChatCompletionsClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public ChatCompletionsClientBuilder scopes(String[] scopes) {
        this.scopes = scopes;
        return this;
    }

    public ChatCompletionsClientBuilder credential(KeyCredential keyCredential) {
        this.keyCredential = keyCredential;
        return this;
    }

    public ChatCompletionsClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ChatCompletionsClientBuilder serviceVersion(ModelServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public ChatCompletionsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private ChatCompletionsClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        ModelServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : ModelServiceVersion.getLatest();
        ChatCompletionsClientImpl client = new ChatCompletionsClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, localServiceVersion);
        return client;
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.keyCredential != null) {
            policies.add(new KeyCredentialPolicy("api-key", this.keyCredential));
        }
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, this.scopes));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public ChatCompletionsAsyncClient buildAsyncClient() {
        return new ChatCompletionsAsyncClient(this.buildInnerClient());
    }

    public ChatCompletionsClient buildClient() {
        return new ChatCompletionsClient(this.buildInnerClient());
    }
}

