/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.ImageEmbeddingsClientBuilder;
import com.azure.ai.inference.implementation.ImageEmbeddingsClientImpl;
import com.azure.ai.inference.implementation.models.ImageEmbedRequest;
import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInput;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.ai.inference.models.EmbeddingsResult;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import java.util.List;

@ServiceClient(builder=ImageEmbeddingsClientBuilder.class)
public final class ImageEmbeddingsClient {
    private final ImageEmbeddingsClientImpl serviceClient;

    ImageEmbeddingsClient(ImageEmbeddingsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> embedWithResponse(BinaryData embedRequest1, RequestOptions requestOptions) {
        return this.serviceClient.embedWithResponse(embedRequest1, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    EmbeddingsResult embed(List<EmbeddingInput> input) {
        RequestOptions requestOptions = new RequestOptions();
        ImageEmbedRequest embedRequest1Obj = new ImageEmbedRequest(input);
        BinaryData embedRequest1 = BinaryData.fromObject((Object)embedRequest1Obj);
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(embedRequest1, requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ModelInfo getModelInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return (ModelInfo)((BinaryData)this.getModelInfoWithResponse(requestOptions).getValue()).toObject(ModelInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    EmbeddingsResult embed(List<EmbeddingInput> input, ExtraParameters extraParams, Integer dimensions, EmbeddingEncodingFormat encodingFormat, EmbeddingInputType inputType, String model) {
        RequestOptions requestOptions = new RequestOptions();
        ImageEmbedRequest embedRequest1Obj = new ImageEmbedRequest(input).setDimensions(dimensions).setEncodingFormat(encodingFormat).setInputType(inputType).setModel(model);
        BinaryData embedRequest1 = BinaryData.fromObject((Object)embedRequest1Obj);
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(embedRequest1, requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }
}

