/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.ChatCompletionsResponseFormat;
import com.azure.ai.inference.models.ChatCompletionsToolDefinition;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CompleteRequest
implements JsonSerializable<CompleteRequest> {
    private final List<ChatRequestMessage> messages;
    private Double frequencyPenalty;
    private Boolean stream;
    private Double presencePenalty;
    private Double temperature;
    private Double topP;
    private Integer maxTokens;
    private ChatCompletionsResponseFormat responseFormat;
    private List<String> stop;
    private List<ChatCompletionsToolDefinition> tools;
    private BinaryData toolChoice;
    private Long seed;
    private String model;
    private Map<String, Object> additionalProperties;

    public CompleteRequest(List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public CompleteRequest setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public CompleteRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public CompleteRequest setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CompleteRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CompleteRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public CompleteRequest setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public CompleteRequest setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public CompleteRequest setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    public CompleteRequest setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public CompleteRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public Long getSeed() {
        return this.seed;
    }

    public CompleteRequest setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public CompleteRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public CompleteRequest setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("frequency_penalty", (Number)this.frequencyPenalty);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("presence_penalty", (Number)this.presencePenalty);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeNumberField("max_tokens", (Number)this.maxTokens);
        jsonWriter.writeJsonField("response_format", (JsonSerializable)this.responseFormat);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.toolChoice != null) {
            jsonWriter.writeUntypedField("tool_choice", this.toolChoice.toObject(Object.class));
        }
        jsonWriter.writeNumberField("seed", (Number)this.seed);
        jsonWriter.writeStringField("model", this.model);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CompleteRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CompleteRequest)jsonReader.readObject(reader -> {
            List messages = null;
            Double frequencyPenalty = null;
            Boolean stream = null;
            Double presencePenalty = null;
            Double temperature = null;
            Double topP = null;
            Integer maxTokens = null;
            ChatCompletionsResponseFormat responseFormat = null;
            List stop = null;
            List tools = null;
            BinaryData toolChoice = null;
            Long seed = null;
            String model = null;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> ChatRequestMessage.fromJson(reader1));
                    continue;
                }
                if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_tokens".equals(fieldName)) {
                    maxTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = ChatCompletionsResponseFormat.fromJson(reader);
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ChatCompletionsToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("seed".equals(fieldName)) {
                    seed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            CompleteRequest deserializedCompleteRequest = new CompleteRequest(messages);
            deserializedCompleteRequest.frequencyPenalty = frequencyPenalty;
            deserializedCompleteRequest.stream = stream;
            deserializedCompleteRequest.presencePenalty = presencePenalty;
            deserializedCompleteRequest.temperature = temperature;
            deserializedCompleteRequest.topP = topP;
            deserializedCompleteRequest.maxTokens = maxTokens;
            deserializedCompleteRequest.responseFormat = responseFormat;
            deserializedCompleteRequest.stop = stop;
            deserializedCompleteRequest.tools = tools;
            deserializedCompleteRequest.toolChoice = toolChoice;
            deserializedCompleteRequest.seed = seed;
            deserializedCompleteRequest.model = model;
            deserializedCompleteRequest.additionalProperties = additionalProperties;
            return deserializedCompleteRequest;
        });
    }
}

