/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatMessageContentItem;
import com.azure.ai.inference.models.ChatMessageImageContentItem;
import com.azure.ai.inference.models.ChatMessageTextContentItem;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public final class ChatRequestUserMessage
extends ChatRequestMessage {
    private ChatRole role = ChatRole.USER;
    private final BinaryData content;

    public ChatRequestUserMessage(BinaryData content) {
        this.content = content;
    }

    public ChatRequestUserMessage(String content) {
        String contentString = String.format("\"%s\"", content);
        this.content = BinaryData.fromString((String)contentString);
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    public BinaryData getContent() {
        return this.content;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("content", this.content.toObject(Object.class));
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestUserMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestUserMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.USER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestUserMessage deserializedChatRequestUserMessage = new ChatRequestUserMessage(content);
            deserializedChatRequestUserMessage.role = role;
            return deserializedChatRequestUserMessage;
        });
    }

    public static ChatRequestUserMessage fromString(String content) {
        String jsonPrompt = "{\"content\":\"%s\"}";
        String contentString = String.format(jsonPrompt, content);
        try {
            return ChatRequestUserMessage.fromJson(JsonProviders.createReader((Reader)new StringReader(contentString)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ChatRequestUserMessage fromContentItems(List<ChatMessageContentItem> contentItems) {
        if (contentItems == null || contentItems.isEmpty()) {
            throw new RuntimeException("Content items cannot be null or empty.");
        }
        String jsonPrompt = "{\"content\":[";
        for (ChatMessageContentItem item : contentItems) {
            if (item instanceof ChatMessageTextContentItem) {
                ChatMessageTextContentItem textItem = (ChatMessageTextContentItem)item;
                String textPrompt = "{\"type\": \"text\", \"text\":\"%s\"}";
                jsonPrompt = jsonPrompt + String.format(textPrompt, textItem.getText());
            } else if (item instanceof ChatMessageImageContentItem) {
                ChatMessageImageContentItem imageItem = (ChatMessageImageContentItem)item;
                String imageUrlPrompt = "{\"type\": \"image_url\", \"image_url\":{ \"url\": \"%s\"}}";
                jsonPrompt = jsonPrompt + String.format(imageUrlPrompt, imageItem.getImageUrl().getUrl());
            }
            jsonPrompt = jsonPrompt + ",";
        }
        jsonPrompt = jsonPrompt.substring(0, jsonPrompt.length() - 1);
        jsonPrompt = jsonPrompt + "]}";
        try {
            return ChatRequestUserMessage.fromJson(JsonProviders.createReader((Reader)new StringReader(jsonPrompt)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

