/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.AudioTranscriptionValidator;
import com.azure.ai.openai.implementation.AudioTranslationValidator;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.EmbeddingsUtils;
import com.azure.ai.openai.implementation.MultipartFormDataHelper;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.implementation.OpenAIUtils;
import com.azure.ai.openai.implementation.accesshelpers.PageableListAccessHelper;
import com.azure.ai.openai.implementation.models.FileListResponse;
import com.azure.ai.openai.implementation.models.OpenAIPageableListOfBatch;
import com.azure.ai.openai.implementation.models.UploadFileRequest;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.Batch;
import com.azure.ai.openai.models.BatchCreateRequest;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.FileDeletionStatus;
import com.azure.ai.openai.models.FileDetails;
import com.azure.ai.openai.models.FilePurpose;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.OpenAIFile;
import com.azure.ai.openai.models.PageableList;
import com.azure.ai.openai.models.SpeechGenerationOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=OpenAIClientBuilder.class, isAsync=true)
public final class OpenAIAsyncClient {
    private final OpenAIClientImpl serviceClient;
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIAsyncClient.class);
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    OpenAIAsyncClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIAsyncClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        BinaryData embeddingsOptionsUpdated = EmbeddingsUtils.addEncodingFormat(embeddingsOptions);
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponseAsync(deploymentOrModelName, embeddingsOptionsUpdated, requestOptions) : this.serviceClient.getEmbeddingsWithResponseAsync(deploymentOrModelName, embeddingsOptionsUpdated, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponseAsync(deploymentOrModelName, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponseAsync(deploymentOrModelName, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponseAsync(deploymentOrModelName, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponseAsync(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Embeddings>> getEmbeddingsWithResponse(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        return this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((Embeddings)((BinaryData)response.getValue()).toObject(Embeddings.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Completions>> getCompletionsWithResponse(String deploymentOrModelName, CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        return this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((Completions)((BinaryData)response.getValue()).toObject(Completions.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatCompletions>> getChatCompletionsWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        return this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((ChatCompletions)((BinaryData)response.getValue()).toObject(ChatCompletions.class))));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<Response<ChatCompletions>> getChatCompletionsStreamWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        chatCompletionsOptions.setStream(true);
        Mono<Response<BinaryData>> chatCompletionsWithResponse = this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions);
        AtomicReference responseCopy = new AtomicReference();
        Flux responseStream = chatCompletionsWithResponse.flatMapMany(response -> {
            responseCopy.set(response);
            return ((BinaryData)response.getValue()).toFluxByteBuffer();
        });
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return chatCompletionsStream.getEvents().map(chatCompletions -> new SimpleResponse((Response)responseCopy.get(), chatCompletions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Embeddings> getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Embeddings)protocolMethodData.toObject(Embeddings.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Completions)protocolMethodData.toObject(Completions.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentOrModelName, String prompt) {
        return this.getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        BinaryData requestBody = BinaryData.fromObject((Object)completionsOptions);
        Flux responseStream = this.getCompletionsWithResponse(deploymentOrModelName, requestBody, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return completionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatCompletions> getChatCompletions(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ChatCompletions)protocolMethodData.toObject(ChatCompletions.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return chatCompletionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranscription> getAudioTranscription(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AudioTranscription>> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        try {
            AudioTranscriptionValidator.validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranscriptionOptions.getFile()), fileName);
        String temperature = audioTranscriptionOptions.getTemperature() == null ? null : String.valueOf(audioTranscriptionOptions.getTemperature());
        MultipartFormDataHelper multipartRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString()).serializeTextField("model", audioTranscriptionOptions.getModel()).serializeTextField("prompt", audioTranscriptionOptions.getPrompt()).serializeTextField("language", audioTranscriptionOptions.getLanguage()).serializeTextField("temperature", temperature);
        List<AudioTranscriptionTimestampGranularity> timestampGranularities = audioTranscriptionOptions.getTimestampGranularities();
        if (!CoreUtils.isNullOrEmpty(timestampGranularities)) {
            for (AudioTranscriptionTimestampGranularity timestampGranularity : timestampGranularities) {
                multipartRequest.serializeTextField("timestamp_granularities[]", timestampGranularity.toString());
            }
        }
        BinaryData uploadFileRequest = multipartRequest.end().getRequestBody();
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((AudioTranscription)((BinaryData)responseBinaryData.getValue()).toObject(AudioTranscription.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranscriptionText(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        try {
            AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranscriptionOptions.getFile()), fileName);
        String temperature = audioTranscriptionOptions.getTemperature() == null ? null : String.valueOf(audioTranscriptionOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString()).serializeTextField("model", audioTranscriptionOptions.getModel()).serializeTextField("prompt", audioTranscriptionOptions.getPrompt()).serializeTextField("language", audioTranscriptionOptions.getLanguage()).serializeTextField("temperature", temperature).end().getRequestBody();
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return response.map(dataResponse -> new SimpleResponse(dataResponse, (Object)((BinaryData)dataResponse.getValue()).toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranslation> getAudioTranslation(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AudioTranslation>> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        try {
            AudioTranslationValidator.validateAudioResponseFormatForTranslation(audioTranslationOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranslationOptions.getFile()), fileName);
        String temperature = audioTranslationOptions.getTemperature() == null ? null : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString()).serializeTextField("model", audioTranslationOptions.getModel()).serializeTextField("prompt", audioTranslationOptions.getPrompt()).serializeTextField("temperature", temperature).end().getRequestBody();
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((AudioTranslation)((BinaryData)responseBinaryData.getValue()).toObject(AudioTranslation.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranslationText(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        try {
            AudioTranslationValidator.validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranslationOptions.getFile()), fileName);
        String temperature = audioTranslationOptions.getTemperature() == null ? null : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString()).serializeTextField("model", audioTranslationOptions.getModel()).serializeTextField("prompt", audioTranslationOptions.getPrompt()).serializeTextField("temperature", temperature).end().getRequestBody();
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((BinaryData)responseBinaryData.getValue()).toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranscriptionAsPlainText(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (String)protocolMethodData.toObject(String.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranslationAsPlainText(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (String)protocolMethodData.toObject(String.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getImageGenerationsWithResponse(String deploymentOrModelName, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getImageGenerationsWithResponseAsync(deploymentOrModelName, imageGenerationOptions, requestOptions) : this.serviceClient.getImageGenerationsWithResponseAsync(deploymentOrModelName, imageGenerationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ImageGenerations>> getImageGenerationsWithResponse(String deploymentOrModelName, ImageGenerationOptions imageGenerationOptions, RequestOptions requestOptions) {
        return this.getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)imageGenerationOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((ImageGenerations)((BinaryData)response.getValue()).toObject(ImageGenerations.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ImageGenerations> getImageGenerations(String deploymentOrModelName, ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)imageGenerationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ImageGenerations)protocolMethodData.toObject(ImageGenerations.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<AudioTranscription> getAudioTranscriptionAsResponseObject(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscription(deploymentOrModelName, "filename", audioTranscriptionOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<AudioTranslation> getAudioTranslationAsResponseObject(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslation(deploymentOrModelName, "filename", audioTranslationOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> generateSpeechFromTextWithResponse(String deploymentOrModelName, BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        BinaryData speechGenerationOptionsWithModelId = NonAzureOpenAIClientImpl.addModelIdJson(speechGenerationOptions, deploymentOrModelName);
        return this.openAIServiceClient != null ? this.openAIServiceClient.generateSpeechFromTextWithResponseAsync(deploymentOrModelName, speechGenerationOptionsWithModelId, requestOptions) : this.serviceClient.generateSpeechFromTextWithResponseAsync(deploymentOrModelName, speechGenerationOptionsWithModelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> generateSpeechFromText(String deploymentOrModelName, SpeechGenerationOptions speechGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.generateSpeechFromTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)speechGenerationOptions), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<OpenAIFile>>> listFilesWithResponse(RequestOptions requestOptions) {
        Mono<Response<BinaryData>> listedFilesWithResponse;
        if (this.openAIServiceClient != null) {
            listedFilesWithResponse = this.openAIServiceClient.listFilesWithResponseAsync(requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            listedFilesWithResponse = this.serviceClient.listFilesWithResponseAsync(requestOptions);
        }
        return listedFilesWithResponse.map(response -> new SimpleResponse(response, ((FileListResponse)((BinaryData)response.getValue()).toObject(FileListResponse.class)).getData()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<OpenAIFile>> uploadFileWithResponse(BinaryData uploadFileRequest, RequestOptions requestOptions) {
        Mono uploadedFileWithResponse;
        if (this.openAIServiceClient != null) {
            uploadedFileWithResponse = this.openAIServiceClient.uploadFileWithResponseAsync(uploadFileRequest, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            uploadedFileWithResponse = this.serviceClient.uploadFileWithResponseAsync(uploadFileRequest, requestOptions).onErrorResume(HttpResponseException.class, throwable -> {
                HttpResponseException ex = (HttpResponseException)throwable;
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 201) {
                    return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)BinaryData.fromObject((Object)ex.getValue()), null));
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return uploadedFileWithResponse.map(response -> new SimpleResponse(response, (Object)((OpenAIFile)((BinaryData)response.getValue()).toObject(OpenAIFile.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileDeletionStatus>> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        Mono deletedFileWithResponse;
        if (this.openAIServiceClient != null) {
            deletedFileWithResponse = this.openAIServiceClient.deleteFileWithResponseAsync(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            deletedFileWithResponse = this.serviceClient.deleteFileWithResponseAsync(fileId, requestOptions).onErrorResume(HttpResponseException.class, throwable -> {
                HttpResponseException ex = (HttpResponseException)throwable;
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 204) {
                    return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)BinaryData.fromObject((Object)ex.getValue()), null));
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return deletedFileWithResponse.map(response -> new SimpleResponse(response, (Object)((FileDeletionStatus)((BinaryData)response.getValue()).toObject(FileDeletionStatus.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OpenAIFile>> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        Mono<Response<BinaryData>> retrievedFileWithResponse;
        if (this.openAIServiceClient != null) {
            retrievedFileWithResponse = this.openAIServiceClient.getFileWithResponseAsync(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            retrievedFileWithResponse = this.serviceClient.getFileWithResponseAsync(fileId, requestOptions);
        }
        return retrievedFileWithResponse.map(response -> new SimpleResponse(response, (Object)((OpenAIFile)((BinaryData)response.getValue()).toObject(OpenAIFile.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        Mono<Response<BinaryData>> fileContentWithResponse;
        if (this.openAIServiceClient != null) {
            fileContentWithResponse = this.openAIServiceClient.getFileContentWithResponseAsync(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            fileContentWithResponse = this.serviceClient.getFileContentWithResponseAsync(fileId, requestOptions);
        }
        return fileContentWithResponse.map(response -> new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toBytes()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageableList<Batch>>> listBatchesWithResponse(RequestOptions requestOptions) {
        Mono<Response<BinaryData>> listedBatchesWithResponse;
        if (this.openAIServiceClient != null) {
            listedBatchesWithResponse = this.openAIServiceClient.listBatchesWithResponseAsync(requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            listedBatchesWithResponse = this.serviceClient.listBatchesWithResponseAsync(requestOptions);
        }
        return listedBatchesWithResponse.map(response -> {
            OpenAIPageableListOfBatch batchList = (OpenAIPageableListOfBatch)((BinaryData)response.getValue()).toObject(OpenAIPageableListOfBatch.class);
            return new SimpleResponse(response, PageableListAccessHelper.create(batchList.getData(), batchList.getFirstId(), batchList.getLastId(), batchList.isHasMore()));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Batch>> createBatchWithResponse(BinaryData createBatchRequest, RequestOptions requestOptions) {
        Mono createdBatchWithResponse;
        if (this.openAIServiceClient != null) {
            createdBatchWithResponse = this.openAIServiceClient.createBatchWithResponseAsync(createBatchRequest, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            createdBatchWithResponse = this.serviceClient.createBatchWithResponseAsync(createBatchRequest, requestOptions).onErrorResume(HttpResponseException.class, throwable -> {
                HttpResponseException ex = (HttpResponseException)throwable;
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 200) {
                    return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)BinaryData.fromObject((Object)ex.getValue()), null));
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return createdBatchWithResponse.map(response -> new SimpleResponse(response, (Object)((Batch)((BinaryData)response.getValue()).toObject(Batch.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Batch>> getBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Mono<Response<BinaryData>> retrievedBatchWithResponse;
        if (this.openAIServiceClient != null) {
            retrievedBatchWithResponse = this.openAIServiceClient.getBatchWithResponseAsync(batchId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            retrievedBatchWithResponse = this.serviceClient.getBatchWithResponseAsync(batchId, requestOptions);
        }
        return retrievedBatchWithResponse.map(response -> new SimpleResponse(response, (Object)((Batch)((BinaryData)response.getValue()).toObject(Batch.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Batch>> cancelBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Mono<Response<BinaryData>> cancelledBatchWithResponse;
        if (this.openAIServiceClient != null) {
            cancelledBatchWithResponse = this.openAIServiceClient.cancelBatchWithResponseAsync(batchId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            cancelledBatchWithResponse = this.serviceClient.cancelBatchWithResponseAsync(batchId, requestOptions);
        }
        return cancelledBatchWithResponse.map(response -> new SimpleResponse(response, (Object)((Batch)((BinaryData)response.getValue()).toObject(Batch.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<OpenAIFile>> listFiles(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return this.listFilesWithResponse(requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<OpenAIFile>> listFiles() {
        return this.listFiles(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OpenAIFile> uploadFile(FileDetails file, FilePurpose purpose, String filename) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose).setFilename(filename);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions).serializeFileField("file", uploadFileRequestObj.getFile().getContent(), uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)uploadFileRequestObj.getPurpose())).serializeTextField("filename", uploadFileRequestObj.getFilename()).end().getRequestBody();
        return this.uploadFileWithResponse(uploadFileRequest, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenAIFile> uploadFile(FileDetails file, FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions).serializeFileField("file", uploadFileRequestObj.getFile().getContent(), uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)uploadFileRequestObj.getPurpose())).serializeTextField("filename", uploadFileRequestObj.getFilename()).end().getRequestBody();
        return this.uploadFileWithResponse(uploadFileRequest, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileDeletionStatus> deleteFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteFileWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenAIFile> getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileContentWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<Batch>> listBatches(String after, Integer limit) {
        RequestOptions requestOptions = new RequestOptions();
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        return this.listBatchesWithResponse(requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<Batch>> listBatches() {
        return this.listBatches(null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Batch> getBatch(String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getBatchWithResponse(batchId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Batch> cancelBatch(String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelBatchWithResponse(batchId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Batch> createBatch(BatchCreateRequest createBatchRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createBatchWithResponse(BinaryData.fromObject((Object)createBatchRequest), requestOptions).flatMap(FluxUtil::toMono);
    }
}

