/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataContextProperty;
import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.ai.openai.models.PineconeFieldMappingOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PineconeChatExtensionParameters
implements JsonSerializable<PineconeChatExtensionParameters> {
    private OnYourDataAuthenticationOptions authentication;
    private Integer topNDocuments;
    private Boolean inScope;
    private Integer strictness;
    private String roleInformation;
    private final String environment;
    private final String indexName;
    private final PineconeFieldMappingOptions fieldsMapping;
    private final OnYourDataVectorizationSource embeddingDependency;
    private Integer maxSearchQueries;
    private Boolean allowPartialResult;
    private List<OnYourDataContextProperty> includeContexts;

    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    public PineconeChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    public PineconeChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    public Boolean isInScope() {
        return this.inScope;
    }

    public PineconeChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    public Integer getStrictness() {
        return this.strictness;
    }

    public PineconeChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    public String getRoleInformation() {
        return this.roleInformation;
    }

    public PineconeChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public PineconeFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    public PineconeChatExtensionParameters(String environment, String indexName, PineconeFieldMappingOptions fieldsMapping, OnYourDataVectorizationSource embeddingDependency) {
        this.environment = environment;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
        this.embeddingDependency = embeddingDependency;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environment", this.environment);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("fields_mapping", (JsonSerializable)this.fieldsMapping);
        jsonWriter.writeJsonField("embedding_dependency", (JsonSerializable)this.embeddingDependency);
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeNumberField("top_n_documents", (Number)this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", (Number)this.strictness);
        jsonWriter.writeStringField("role_information", this.roleInformation);
        jsonWriter.writeNumberField("max_search_queries", (Number)this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static PineconeChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PineconeChatExtensionParameters)jsonReader.readObject(reader -> {
            String environment = null;
            String indexName = null;
            PineconeFieldMappingOptions fieldsMapping = null;
            OnYourDataVectorizationSource embeddingDependency = null;
            OnYourDataAuthenticationOptions authentication = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            String roleInformation = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List includeContexts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environment".equals(fieldName)) {
                    environment = reader.getString();
                    continue;
                }
                if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                    continue;
                }
                if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = PineconeFieldMappingOptions.fromJson(reader);
                    continue;
                }
                if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency = OnYourDataVectorizationSource.fromJson(reader);
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                    continue;
                }
                if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("in_scope".equals(fieldName)) {
                    inScope = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("strictness".equals(fieldName)) {
                    strictness = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("role_information".equals(fieldName)) {
                    roleInformation = reader.getString();
                    continue;
                }
                if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("include_contexts".equals(fieldName)) {
                    includeContexts = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            PineconeChatExtensionParameters deserializedPineconeChatExtensionParameters = new PineconeChatExtensionParameters(environment, indexName, fieldsMapping, embeddingDependency);
            deserializedPineconeChatExtensionParameters.authentication = authentication;
            deserializedPineconeChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedPineconeChatExtensionParameters.inScope = inScope;
            deserializedPineconeChatExtensionParameters.strictness = strictness;
            deserializedPineconeChatExtensionParameters.roleInformation = roleInformation;
            deserializedPineconeChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedPineconeChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedPineconeChatExtensionParameters.includeContexts = includeContexts;
            return deserializedPineconeChatExtensionParameters;
        });
    }

    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    public PineconeChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    public PineconeChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    public PineconeChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}

