/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.CommunicationSpiManager;
import com.baidu.brpc.GovernanceSpiManager;
import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.FastFutureStore;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.client.channel.Endpoint;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.loadbalance.LoadBalanceManager;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.naming.NamingServiceProcessor;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.thread.ShutDownManager;
import com.baidu.brpc.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient {
    private static final Logger log = LoggerFactory.getLogger(RpcClient.class);
    private RpcClientOptions rpcClientOptions = new RpcClientOptions();
    private CommunicationOptions communicationOptions;
    private LoadBalanceStrategy loadBalanceStrategy;
    private AtomicBoolean stop = new AtomicBoolean(false);
    private NamingServiceProcessor namingServiceProcessor;
    private AtomicBoolean globalInit = new AtomicBoolean(false);
    private Class serviceInterface;
    private String namingServiceUrl;
    private List<Endpoint> endpoints;

    public RpcClient(String namingServiceUrl) {
        this(namingServiceUrl, new RpcClientOptions(), null);
    }

    public RpcClient(String namingServiceUrl, RpcClientOptions options) {
        this(namingServiceUrl, options, null);
    }

    public RpcClient(String namingServiceUrl, RpcClientOptions options, List<Interceptor> interceptors) {
        Validate.notEmpty((CharSequence)namingServiceUrl);
        this.namingServiceUrl = namingServiceUrl;
        this.init(options, interceptors);
    }

    public RpcClient(Endpoint endPoint) {
        this(endPoint, null);
    }

    public RpcClient(Endpoint endPoint, RpcClientOptions options) {
        this(endPoint, options, null);
    }

    public RpcClient(Endpoint endPoint, RpcClientOptions options, List<Interceptor> interceptors) {
        this.endpoints = new ArrayList<Endpoint>(1);
        this.endpoints.add(endPoint);
        this.init(options, interceptors);
    }

    public RpcClient(List<Endpoint> endPoints) {
        this(endPoints, new RpcClientOptions(), null);
    }

    public RpcClient(List<Endpoint> endPoints, RpcClientOptions options) {
        this(endPoints, options, null);
    }

    public RpcClient(List<Endpoint> endPoints, RpcClientOptions options, List<Interceptor> interceptors) {
        Validate.notEmpty(endPoints);
        this.endpoints = endPoints;
        this.init(options, interceptors);
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz, NamingOptions namingOptions) {
        return BrpcProxy.getProxy(rpcClient, clazz, namingOptions);
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz) {
        return BrpcProxy.getProxy(rpcClient, clazz, null);
    }

    public void registerPushService(Object service) {
        ServiceManager.getInstance().registerPushService(service);
        if (this.namingServiceProcessor.getInstances().size() == 0) {
            log.error("there should be have normal services before register push service.");
            throw new RpcException("there should be have normal services before register push service");
        }
    }

    public <T> T getProxy(Class clazz, NamingOptions namingOptions) {
        return BrpcProxy.getProxy(this, clazz, namingOptions);
    }

    public <T> T getProxy(Class clazz) {
        return BrpcProxy.getProxy(this, clazz, null);
    }

    public void setServiceInterface(Class clazz) {
        this.setServiceInterface(clazz, null);
    }

    public void setServiceInterface(Class clazz, NamingOptions namingOptions) {
        if (this.serviceInterface != null) {
            throw new RpcException("serviceInterface must not be set repeatedly, please use another RpcClient");
        }
        this.serviceInterface = clazz.getInterfaces().length == 0 ? clazz : clazz.getInterfaces()[0];
        this.namingServiceProcessor = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.namingServiceUrl}) ? new NamingServiceProcessor(this.namingServiceUrl, this.serviceInterface, namingOptions, this.rpcClientOptions.getHealthyCheckIntervalMillis(), this.communicationOptions) : new NamingServiceProcessor(this.endpoints, this.serviceInterface, this.rpcClientOptions.getHealthyCheckIntervalMillis(), this.communicationOptions);
    }

    public void shutdown() {
        this.stop();
    }

    public void stop() {
        if (this.stop.compareAndSet(false, true)) {
            if (this.namingServiceProcessor != null) {
                this.namingServiceProcessor.stop();
            }
            if (this.loadBalanceStrategy != null) {
                this.loadBalanceStrategy.destroy();
            }
        }
    }

    public boolean isShutdown() {
        return this.stop.get();
    }

    public Response execute(Request request, CommunicationOptions communicationOptions) throws RpcException {
        List<CommunicationClient> instances = this.namingServiceProcessor.getInstances();
        CommunicationClient client = this.loadBalanceStrategy.selectInstance(request, instances, request.getSelectedInstances());
        if (client == null) {
            log.warn("no available server instance");
            throw new RpcException(1, "no available server instance");
        }
        if (log.isDebugEnabled()) {
            log.debug("select instance {}", (Object)client.getServiceInstance());
        }
        Response response = communicationOptions.getProtocol().createResponse();
        client.executeChain(request, response);
        return response;
    }

    private void init(RpcClientOptions options, List<Interceptor> interceptors) {
        if (CollectionUtils.isEmpty(interceptors)) {
            interceptors = new ArrayList<Interceptor>();
        }
        if (null == options) {
            this.rpcClientOptions = new RpcClientOptions();
        } else {
            try {
                this.rpcClientOptions.copyFrom(options);
            }
            catch (Exception ex) {
                log.warn("init rpc options failed, so use default");
                this.rpcClientOptions = new RpcClientOptions();
            }
        }
        this.initGlobal(this.rpcClientOptions);
        this.communicationOptions = this.rpcClientOptions.buildCommunicationOptions(interceptors);
        this.loadBalanceStrategy = LoadBalanceManager.getInstance().createLoadBalance(this.rpcClientOptions.getLoadBalanceType());
        this.loadBalanceStrategy.init(this);
    }

    public void initGlobal(RpcClientOptions options) {
        if (this.globalInit.compareAndSet(false, true)) {
            CommunicationSpiManager.getInstance().loadAllExtensions(options.getEncoding());
            GovernanceSpiManager.getInstance().loadAllExtensions();
            FastFutureStore.getInstance((int)options.getFutureBufferSize());
            ShutDownManager.getInstance();
        }
    }

    public RpcClientOptions getRpcClientOptions() {
        return this.rpcClientOptions;
    }

    public CommunicationOptions getCommunicationOptions() {
        return this.communicationOptions;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public NamingServiceProcessor getNamingServiceProcessor() {
        return this.namingServiceProcessor;
    }

    public AtomicBoolean getGlobalInit() {
        return this.globalInit;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public String getNamingServiceUrl() {
        return this.namingServiceUrl;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }
}

